/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ssl.certificates;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CertificateInformation
implements JsonpSerializable {
    @Nullable
    private final String alias;
    private final String expiry;
    private final String format;
    private final boolean hasPrivateKey;
    private final String path;
    private final String serialNumber;
    private final String subjectDn;
    public static final JsonpDeserializer<CertificateInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CertificateInformation::setupCertificateInformationDeserializer, Builder::build);

    public CertificateInformation(Builder builder) {
        this.alias = builder.alias;
        this.expiry = Objects.requireNonNull(builder.expiry, "expiry");
        this.format = Objects.requireNonNull(builder.format, "format");
        this.hasPrivateKey = Objects.requireNonNull(builder.hasPrivateKey, "has_private_key");
        this.path = Objects.requireNonNull(builder.path, "path");
        this.serialNumber = Objects.requireNonNull(builder.serialNumber, "serial_number");
        this.subjectDn = Objects.requireNonNull(builder.subjectDn, "subject_dn");
    }

    public CertificateInformation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String alias() {
        return this.alias;
    }

    public String expiry() {
        return this.expiry;
    }

    public String format() {
        return this.format;
    }

    public boolean hasPrivateKey() {
        return this.hasPrivateKey;
    }

    public String path() {
        return this.path;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public String subjectDn() {
        return this.subjectDn;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alias != null) {
            generator.writeKey("alias");
            generator.write(this.alias);
        }
        generator.writeKey("expiry");
        generator.write(this.expiry);
        generator.writeKey("format");
        generator.write(this.format);
        generator.writeKey("has_private_key");
        generator.write(this.hasPrivateKey);
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("serial_number");
        generator.write(this.serialNumber);
        generator.writeKey("subject_dn");
        generator.write(this.subjectDn);
    }

    protected static void setupCertificateInformationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::alias, JsonpDeserializer.stringDeserializer(), "alias", new String[0]);
        op.add(Builder::expiry, JsonpDeserializer.stringDeserializer(), "expiry", new String[0]);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::hasPrivateKey, JsonpDeserializer.booleanDeserializer(), "has_private_key", new String[0]);
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path", new String[0]);
        op.add(Builder::serialNumber, JsonpDeserializer.stringDeserializer(), "serial_number", new String[0]);
        op.add(Builder::subjectDn, JsonpDeserializer.stringDeserializer(), "subject_dn", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CertificateInformation> {
        @Nullable
        private String alias;
        private String expiry;
        private String format;
        private Boolean hasPrivateKey;
        private String path;
        private String serialNumber;
        private String subjectDn;

        public Builder alias(@Nullable String value) {
            this.alias = value;
            return this;
        }

        public Builder expiry(String value) {
            this.expiry = value;
            return this;
        }

        public Builder format(String value) {
            this.format = value;
            return this;
        }

        public Builder hasPrivateKey(boolean value) {
            this.hasPrivateKey = value;
            return this;
        }

        public Builder path(String value) {
            this.path = value;
            return this;
        }

        public Builder serialNumber(String value) {
            this.serialNumber = value;
            return this;
        }

        public Builder subjectDn(String value) {
            this.subjectDn = value;
            return this;
        }

        @Override
        public CertificateInformation build() {
            return new CertificateInformation(this);
        }
    }
}

