/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.snapshot.IndexDetails;
import co.elastic.clients.elasticsearch.snapshot.InfoFeatureState;
import co.elastic.clients.elasticsearch.snapshot.SnapshotShardFailure;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SnapshotInfo
implements JsonpSerializable {
    private final List<String> dataStreams;
    @Nullable
    private final String duration;
    @Nullable
    private final String durationInMillis;
    @Nullable
    private final String endTime;
    @Nullable
    private final String endTimeInMillis;
    @Nullable
    private final List<SnapshotShardFailure> failures;
    @Nullable
    private final Boolean includeGlobalState;
    private final List<String> indices;
    @Nullable
    private final Map<String, IndexDetails> indexDetails;
    @Nullable
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String reason;
    @Nullable
    private final String repository;
    private final String snapshot;
    @Nullable
    private final ShardStatistics shards;
    @Nullable
    private final String startTime;
    @Nullable
    private final String startTimeInMillis;
    @Nullable
    private final String state;
    private final String uuid;
    @Nullable
    private final String version;
    @Nullable
    private final Long versionId;
    @Nullable
    private final List<InfoFeatureState> featureStates;
    public static final JsonpDeserializer<SnapshotInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotInfo::setupSnapshotInfoDeserializer, Builder::build);

    public SnapshotInfo(Builder builder) {
        this.dataStreams = ModelTypeHelper.unmodifiableNonNull(builder.dataStreams, "data_streams");
        this.duration = builder.duration;
        this.durationInMillis = builder.durationInMillis;
        this.endTime = builder.endTime;
        this.endTimeInMillis = builder.endTimeInMillis;
        this.failures = ModelTypeHelper.unmodifiable(builder.failures);
        this.includeGlobalState = builder.includeGlobalState;
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.indexDetails = ModelTypeHelper.unmodifiable(builder.indexDetails);
        this.metadata = ModelTypeHelper.unmodifiable(builder.metadata);
        this.reason = builder.reason;
        this.repository = builder.repository;
        this.snapshot = Objects.requireNonNull(builder.snapshot, "snapshot");
        this.shards = builder.shards;
        this.startTime = builder.startTime;
        this.startTimeInMillis = builder.startTimeInMillis;
        this.state = builder.state;
        this.uuid = Objects.requireNonNull(builder.uuid, "uuid");
        this.version = builder.version;
        this.versionId = builder.versionId;
        this.featureStates = ModelTypeHelper.unmodifiable(builder.featureStates);
    }

    public SnapshotInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> dataStreams() {
        return this.dataStreams;
    }

    @Nullable
    public String duration() {
        return this.duration;
    }

    @Nullable
    public String durationInMillis() {
        return this.durationInMillis;
    }

    @Nullable
    public String endTime() {
        return this.endTime;
    }

    @Nullable
    public String endTimeInMillis() {
        return this.endTimeInMillis;
    }

    @Nullable
    public List<SnapshotShardFailure> failures() {
        return this.failures;
    }

    @Nullable
    public Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public List<String> indices() {
        return this.indices;
    }

    @Nullable
    public Map<String, IndexDetails> indexDetails() {
        return this.indexDetails;
    }

    @Nullable
    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    @Nullable
    public String repository() {
        return this.repository;
    }

    public String snapshot() {
        return this.snapshot;
    }

    @Nullable
    public ShardStatistics shards() {
        return this.shards;
    }

    @Nullable
    public String startTime() {
        return this.startTime;
    }

    @Nullable
    public String startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public String state() {
        return this.state;
    }

    public String uuid() {
        return this.uuid;
    }

    @Nullable
    public String version() {
        return this.version;
    }

    @Nullable
    public Long versionId() {
        return this.versionId;
    }

    @Nullable
    public List<InfoFeatureState> featureStates() {
        return this.featureStates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("data_streams");
        generator.writeStartArray();
        for (String string : this.dataStreams) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.duration != null) {
            generator.writeKey("duration");
            generator.write(this.duration);
        }
        if (this.durationInMillis != null) {
            generator.writeKey("duration_in_millis");
            generator.write(this.durationInMillis);
        }
        if (this.endTime != null) {
            generator.writeKey("end_time");
            generator.write(this.endTime);
        }
        if (this.endTimeInMillis != null) {
            generator.writeKey("end_time_in_millis");
            generator.write(this.endTimeInMillis);
        }
        if (this.failures != null) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (SnapshotShardFailure snapshotShardFailure : this.failures) {
                snapshotShardFailure.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.includeGlobalState != null) {
            generator.writeKey("include_global_state");
            generator.write(this.includeGlobalState.booleanValue());
        }
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String string : this.indices) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.indexDetails != null) {
            generator.writeKey("index_details");
            generator.writeStartObject();
            for (Map.Entry entry : this.indexDetails.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((IndexDetails)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
        if (this.repository != null) {
            generator.writeKey("repository");
            generator.write(this.repository);
        }
        generator.writeKey("snapshot");
        generator.write(this.snapshot);
        if (this.shards != null) {
            generator.writeKey("shards");
            this.shards.serialize(generator, mapper);
        }
        if (this.startTime != null) {
            generator.writeKey("start_time");
            generator.write(this.startTime);
        }
        if (this.startTimeInMillis != null) {
            generator.writeKey("start_time_in_millis");
            generator.write(this.startTimeInMillis);
        }
        if (this.state != null) {
            generator.writeKey("state");
            generator.write(this.state);
        }
        generator.writeKey("uuid");
        generator.write(this.uuid);
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.versionId != null) {
            generator.writeKey("version_id");
            generator.write(this.versionId.longValue());
        }
        if (this.featureStates != null) {
            generator.writeKey("feature_states");
            generator.writeStartArray();
            for (InfoFeatureState infoFeatureState : this.featureStates) {
                infoFeatureState.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSnapshotInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "data_streams", new String[0]);
        op.add(Builder::duration, JsonpDeserializer.stringDeserializer(), "duration", new String[0]);
        op.add(Builder::durationInMillis, JsonpDeserializer.stringDeserializer(), "duration_in_millis", new String[0]);
        op.add(Builder::endTime, JsonpDeserializer.stringDeserializer(), "end_time", new String[0]);
        op.add(Builder::endTimeInMillis, JsonpDeserializer.stringDeserializer(), "end_time_in_millis", new String[0]);
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(SnapshotShardFailure._DESERIALIZER), "failures", new String[0]);
        op.add(Builder::includeGlobalState, JsonpDeserializer.booleanDeserializer(), "include_global_state", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
        op.add(Builder::indexDetails, JsonpDeserializer.stringMapDeserializer(IndexDetails._DESERIALIZER), "index_details", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason", new String[0]);
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository", new String[0]);
        op.add(Builder::snapshot, JsonpDeserializer.stringDeserializer(), "snapshot", new String[0]);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "shards", new String[0]);
        op.add(Builder::startTime, JsonpDeserializer.stringDeserializer(), "start_time", new String[0]);
        op.add(Builder::startTimeInMillis, JsonpDeserializer.stringDeserializer(), "start_time_in_millis", new String[0]);
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state", new String[0]);
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::versionId, JsonpDeserializer.longDeserializer(), "version_id", new String[0]);
        op.add(Builder::featureStates, JsonpDeserializer.arrayDeserializer(InfoFeatureState._DESERIALIZER), "feature_states", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SnapshotInfo> {
        private List<String> dataStreams;
        @Nullable
        private String duration;
        @Nullable
        private String durationInMillis;
        @Nullable
        private String endTime;
        @Nullable
        private String endTimeInMillis;
        @Nullable
        private List<SnapshotShardFailure> failures;
        @Nullable
        private Boolean includeGlobalState;
        private List<String> indices;
        @Nullable
        private Map<String, IndexDetails> indexDetails;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String reason;
        @Nullable
        private String repository;
        private String snapshot;
        @Nullable
        private ShardStatistics shards;
        @Nullable
        private String startTime;
        @Nullable
        private String startTimeInMillis;
        @Nullable
        private String state;
        private String uuid;
        @Nullable
        private String version;
        @Nullable
        private Long versionId;
        @Nullable
        private List<InfoFeatureState> featureStates;

        public Builder dataStreams(List<String> value) {
            this.dataStreams = value;
            return this;
        }

        public Builder dataStreams(String ... value) {
            this.dataStreams = Arrays.asList(value);
            return this;
        }

        public Builder addDataStreams(String value) {
            if (this.dataStreams == null) {
                this.dataStreams = new ArrayList<String>();
            }
            this.dataStreams.add(value);
            return this;
        }

        public Builder duration(@Nullable String value) {
            this.duration = value;
            return this;
        }

        public Builder durationInMillis(@Nullable String value) {
            this.durationInMillis = value;
            return this;
        }

        public Builder endTime(@Nullable String value) {
            this.endTime = value;
            return this;
        }

        public Builder endTimeInMillis(@Nullable String value) {
            this.endTimeInMillis = value;
            return this;
        }

        public Builder failures(@Nullable List<SnapshotShardFailure> value) {
            this.failures = value;
            return this;
        }

        public Builder failures(SnapshotShardFailure ... value) {
            this.failures = Arrays.asList(value);
            return this;
        }

        public Builder addFailures(SnapshotShardFailure value) {
            if (this.failures == null) {
                this.failures = new ArrayList<SnapshotShardFailure>();
            }
            this.failures.add(value);
            return this;
        }

        public Builder failures(Function<SnapshotShardFailure.Builder, ObjectBuilder<SnapshotShardFailure>> fn) {
            return this.failures(fn.apply(new SnapshotShardFailure.Builder()).build());
        }

        public Builder addFailures(Function<SnapshotShardFailure.Builder, ObjectBuilder<SnapshotShardFailure>> fn) {
            return this.addFailures(fn.apply(new SnapshotShardFailure.Builder()).build());
        }

        public Builder includeGlobalState(@Nullable Boolean value) {
            this.includeGlobalState = value;
            return this;
        }

        public Builder indices(List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder indexDetails(@Nullable Map<String, IndexDetails> value) {
            this.indexDetails = value;
            return this;
        }

        public Builder putIndexDetails(String key, IndexDetails value) {
            if (this.indexDetails == null) {
                this.indexDetails = new HashMap<String, IndexDetails>();
            }
            this.indexDetails.put(key, value);
            return this;
        }

        public Builder indexDetails(String key, Function<IndexDetails.Builder, ObjectBuilder<IndexDetails>> fn) {
            return this.indexDetails(Collections.singletonMap(key, fn.apply(new IndexDetails.Builder()).build()));
        }

        public Builder putIndexDetails(String key, Function<IndexDetails.Builder, ObjectBuilder<IndexDetails>> fn) {
            return this.putIndexDetails(key, fn.apply(new IndexDetails.Builder()).build());
        }

        public Builder metadata(@Nullable Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        public Builder repository(@Nullable String value) {
            this.repository = value;
            return this;
        }

        public Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public Builder shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public Builder startTime(@Nullable String value) {
            this.startTime = value;
            return this;
        }

        public Builder startTimeInMillis(@Nullable String value) {
            this.startTimeInMillis = value;
            return this;
        }

        public Builder state(@Nullable String value) {
            this.state = value;
            return this;
        }

        public Builder uuid(String value) {
            this.uuid = value;
            return this;
        }

        public Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        public Builder versionId(@Nullable Long value) {
            this.versionId = value;
            return this;
        }

        public Builder featureStates(@Nullable List<InfoFeatureState> value) {
            this.featureStates = value;
            return this;
        }

        public Builder featureStates(InfoFeatureState ... value) {
            this.featureStates = Arrays.asList(value);
            return this;
        }

        public Builder addFeatureStates(InfoFeatureState value) {
            if (this.featureStates == null) {
                this.featureStates = new ArrayList<InfoFeatureState>();
            }
            this.featureStates.add(value);
            return this;
        }

        public Builder featureStates(Function<InfoFeatureState.Builder, ObjectBuilder<InfoFeatureState>> fn) {
            return this.featureStates(fn.apply(new InfoFeatureState.Builder()).build());
        }

        public Builder addFeatureStates(Function<InfoFeatureState.Builder, ObjectBuilder<InfoFeatureState>> fn) {
            return this.addFeatureStates(fn.apply(new InfoFeatureState.Builder()).build());
        }

        @Override
        public SnapshotInfo build() {
            return new SnapshotInfo(this);
        }
    }
}

