/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.get_service_accounts;

import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.GlobalPrivilege;
import co.elastic.clients.elasticsearch.security.IndicesPrivileges;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RoleDescriptor
implements JsonpSerializable {
    private final List<String> cluster;
    private final List<IndicesPrivileges> indices;
    @Nullable
    private final List<GlobalPrivilege> global;
    @Nullable
    private final List<ApplicationPrivileges> applications;
    @Nullable
    private final Map<String, JsonData> metadata;
    @Nullable
    private final List<String> runAs;
    @Nullable
    private final Map<String, JsonData> transientMetadata;
    public static final JsonpDeserializer<RoleDescriptor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleDescriptor::setupRoleDescriptorDeserializer, Builder::build);

    public RoleDescriptor(Builder builder) {
        this.cluster = ModelTypeHelper.unmodifiableNonNull(builder.cluster, "cluster");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.global = ModelTypeHelper.unmodifiable(builder.global);
        this.applications = ModelTypeHelper.unmodifiable(builder.applications);
        this.metadata = ModelTypeHelper.unmodifiable(builder.metadata);
        this.runAs = ModelTypeHelper.unmodifiable(builder.runAs);
        this.transientMetadata = ModelTypeHelper.unmodifiable(builder.transientMetadata);
    }

    public RoleDescriptor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> cluster() {
        return this.cluster;
    }

    public List<IndicesPrivileges> indices() {
        return this.indices;
    }

    @Nullable
    public List<GlobalPrivilege> global() {
        return this.global;
    }

    @Nullable
    public List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    @Nullable
    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public List<String> runAs() {
        return this.runAs;
    }

    @Nullable
    public Map<String, JsonData> transientMetadata() {
        return this.transientMetadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster");
        generator.writeStartArray();
        for (String string : this.cluster) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("indices");
        generator.writeStartArray();
        for (IndicesPrivileges indicesPrivileges : this.indices) {
            indicesPrivileges.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.global != null) {
            generator.writeKey("global");
            generator.writeStartArray();
            for (GlobalPrivilege globalPrivilege : this.global) {
                globalPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.applications != null) {
            generator.writeKey("applications");
            generator.writeStartArray();
            for (ApplicationPrivileges applicationPrivileges : this.applications) {
                applicationPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.runAs != null) {
            generator.writeKey("run_as");
            generator.writeStartArray();
            for (String string : this.runAs) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.transientMetadata != null) {
            generator.writeKey("transient_metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.transientMetadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRoleDescriptorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(IndicesPrivileges._DESERIALIZER), "indices", new String[0]);
        op.add(Builder::global, JsonpDeserializer.arrayDeserializer(GlobalPrivilege._DESERIALIZER), "global", new String[0]);
        op.add(Builder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as", new String[0]);
        op.add(Builder::transientMetadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "transient_metadata", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RoleDescriptor> {
        private List<String> cluster;
        private List<IndicesPrivileges> indices;
        @Nullable
        private List<GlobalPrivilege> global;
        @Nullable
        private List<ApplicationPrivileges> applications;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private List<String> runAs;
        @Nullable
        private Map<String, JsonData> transientMetadata;

        public Builder cluster(List<String> value) {
            this.cluster = value;
            return this;
        }

        public Builder cluster(String ... value) {
            this.cluster = Arrays.asList(value);
            return this;
        }

        public Builder addCluster(String value) {
            if (this.cluster == null) {
                this.cluster = new ArrayList<String>();
            }
            this.cluster.add(value);
            return this;
        }

        public Builder indices(List<IndicesPrivileges> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(IndicesPrivileges ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(IndicesPrivileges value) {
            if (this.indices == null) {
                this.indices = new ArrayList<IndicesPrivileges>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder indices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.indices(fn.apply(new IndicesPrivileges.Builder()).build());
        }

        public Builder addIndices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.addIndices(fn.apply(new IndicesPrivileges.Builder()).build());
        }

        public Builder global(@Nullable List<GlobalPrivilege> value) {
            this.global = value;
            return this;
        }

        public Builder global(GlobalPrivilege ... value) {
            this.global = Arrays.asList(value);
            return this;
        }

        public Builder addGlobal(GlobalPrivilege value) {
            if (this.global == null) {
                this.global = new ArrayList<GlobalPrivilege>();
            }
            this.global.add(value);
            return this;
        }

        public Builder global(Function<GlobalPrivilege.Builder, ObjectBuilder<GlobalPrivilege>> fn) {
            return this.global(fn.apply(new GlobalPrivilege.Builder()).build());
        }

        public Builder addGlobal(Function<GlobalPrivilege.Builder, ObjectBuilder<GlobalPrivilege>> fn) {
            return this.addGlobal(fn.apply(new GlobalPrivilege.Builder()).build());
        }

        public Builder applications(@Nullable List<ApplicationPrivileges> value) {
            this.applications = value;
            return this;
        }

        public Builder applications(ApplicationPrivileges ... value) {
            this.applications = Arrays.asList(value);
            return this;
        }

        public Builder addApplications(ApplicationPrivileges value) {
            if (this.applications == null) {
                this.applications = new ArrayList<ApplicationPrivileges>();
            }
            this.applications.add(value);
            return this;
        }

        public Builder applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build());
        }

        public Builder addApplications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.addApplications(fn.apply(new ApplicationPrivileges.Builder()).build());
        }

        public Builder metadata(@Nullable Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder runAs(@Nullable List<String> value) {
            this.runAs = value;
            return this;
        }

        public Builder runAs(String ... value) {
            this.runAs = Arrays.asList(value);
            return this;
        }

        public Builder addRunAs(String value) {
            if (this.runAs == null) {
                this.runAs = new ArrayList<String>();
            }
            this.runAs.add(value);
            return this;
        }

        public Builder transientMetadata(@Nullable Map<String, JsonData> value) {
            this.transientMetadata = value;
            return this;
        }

        public Builder putTransientMetadata(String key, JsonData value) {
            if (this.transientMetadata == null) {
                this.transientMetadata = new HashMap<String, JsonData>();
            }
            this.transientMetadata.put(key, value);
            return this;
        }

        @Override
        public RoleDescriptor build() {
            return new RoleDescriptor(this);
        }
    }
}

