/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ChangePasswordResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ChangePasswordRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String username;
    @Nullable
    private final JsonValue refresh;
    @Nullable
    private final String password;
    public static final JsonpDeserializer<ChangePasswordRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChangePasswordRequest::setupChangePasswordRequestDeserializer, Builder::build);
    public static final Endpoint<ChangePasswordRequest, ChangePasswordResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ChangePasswordRequest, ChangePasswordResponse>(request -> "PUT", request -> {
        boolean _username = true;
        boolean propsSet = false;
        if (request.username() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.username, buf);
            buf.append("/_password");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/_password");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ChangePasswordResponse._DESERIALIZER);

    public ChangePasswordRequest(Builder builder) {
        this.username = builder.username;
        this.refresh = builder.refresh;
        this.password = builder.password;
    }

    public ChangePasswordRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String username() {
        return this.username;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    @Nullable
    public String password() {
        return this.password;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
    }

    protected static void setupChangePasswordRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ChangePasswordRequest> {
        @Nullable
        private String username;
        @Nullable
        private JsonValue refresh;
        @Nullable
        private String password;

        public Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        public Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        @Override
        public ChangePasswordRequest build() {
            return new ChangePasswordRequest(this);
        }
    }
}

