/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class RollupSearchResponse<TDocument>
implements JsonpSerializable {
    private final long took;
    private final boolean timedOut;
    @Nullable
    private final Boolean terminatedEarly;
    private final ShardStatistics shards;
    private final HitsMetadata<TDocument> hits;
    @Nullable
    private final Map<String, JsonValue> aggregations;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    public RollupSearchResponse(Builder<TDocument> builder) {
        this.took = Objects.requireNonNull(((Builder)builder).took, "took");
        this.timedOut = Objects.requireNonNull(((Builder)builder).timedOut, "timed_out");
        this.terminatedEarly = ((Builder)builder).terminatedEarly;
        this.shards = Objects.requireNonNull(((Builder)builder).shards, "_shards");
        this.hits = Objects.requireNonNull(((Builder)builder).hits, "hits");
        this.aggregations = ModelTypeHelper.unmodifiable(((Builder)builder).aggregations);
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public RollupSearchResponse(Function<Builder<TDocument>, Builder<TDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    public long took() {
        return this.took;
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    @Nullable
    public Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    public HitsMetadata<TDocument> hits() {
        return this.hits;
    }

    @Nullable
    public Map<String, JsonValue> aggregations() {
        return this.aggregations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        if (this.terminatedEarly != null) {
            generator.writeKey("terminated_early");
            generator.write(this.terminatedEarly.booleanValue());
        }
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
        if (this.aggregations != null) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, JsonValue> item0 : this.aggregations.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    public static <TDocument> JsonpDeserializer<RollupSearchResponse<TDocument>> createRollupSearchResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> RollupSearchResponse.setupRollupSearchResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupRollupSearchResponseDeserializer(DelegatingDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took", new String[0]);
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out", new String[0]);
        op.add(Builder::terminatedEarly, JsonpDeserializer.booleanDeserializer(), "terminated_early", new String[0]);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
        op.add(Builder::hits, HitsMetadata.createHitsMetadataDeserializer(tDocumentDeserializer), "hits", new String[0]);
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.jsonValueDeserializer()), "aggregations", new String[0]);
    }

    public static class Builder<TDocument>
    implements ObjectBuilder<RollupSearchResponse<TDocument>> {
        private Long took;
        private Boolean timedOut;
        @Nullable
        private Boolean terminatedEarly;
        private ShardStatistics shards;
        private HitsMetadata<TDocument> hits;
        @Nullable
        private Map<String, JsonValue> aggregations;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder<TDocument> took(long value) {
            this.took = value;
            return this;
        }

        public Builder<TDocument> timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public Builder<TDocument> terminatedEarly(@Nullable Boolean value) {
            this.terminatedEarly = value;
            return this;
        }

        public Builder<TDocument> shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder<TDocument> shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public Builder<TDocument> hits(HitsMetadata<TDocument> value) {
            this.hits = value;
            return this;
        }

        public Builder<TDocument> hits(Function<HitsMetadata.Builder<TDocument>, ObjectBuilder<HitsMetadata<TDocument>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        public Builder<TDocument> aggregations(@Nullable Map<String, JsonValue> value) {
            this.aggregations = value;
            return this;
        }

        public Builder<TDocument> putAggregations(String key, JsonValue value) {
            if (this.aggregations == null) {
                this.aggregations = new HashMap<String, JsonValue>();
            }
            this.aggregations.put(key, value);
            return this;
        }

        public Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public RollupSearchResponse<TDocument> build() {
            return new RollupSearchResponse(this);
        }
    }
}

