/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.rollup.RollupSearchResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RollupSearchRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> index;
    @Nullable
    private final String type;
    @Nullable
    private final Boolean typedKeys;
    @Nullable
    private final Map<String, Aggregation> aggs;
    @Nullable
    private final Query query;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<RollupSearchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupSearchRequest::setupRollupSearchRequestDeserializer, Builder::build);
    private static final SimpleEndpoint<RollupSearchRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_rollup_search");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/_rollup_search");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.typedKeys != null) {
            params.put("typed_keys", String.valueOf(request.typedKeys));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    public RollupSearchRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.type = builder.type;
        this.typedKeys = builder.typedKeys;
        this.aggs = ModelTypeHelper.unmodifiable(builder.aggs);
        this.query = builder.query;
        this.size = builder.size;
    }

    public RollupSearchRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> index() {
        return this.index;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public Boolean typedKeys() {
        return this.typedKeys;
    }

    @Nullable
    public Map<String, Aggregation> aggs() {
        return this.aggs;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aggs != null) {
            generator.writeKey("aggs");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> item0 : this.aggs.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    protected static void setupRollupSearchRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggs, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggs", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
    }

    public static <TDocument> Endpoint<RollupSearchRequest, RollupSearchResponse<TDocument>, ElasticsearchError> createRollupSearchEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ENDPOINT.withResponseDeserializer(RollupSearchResponse.createRollupSearchResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<RollupSearchRequest> {
        private List<String> index;
        @Nullable
        private String type;
        @Nullable
        private Boolean typedKeys;
        @Nullable
        private Map<String, Aggregation> aggs;
        @Nullable
        private Query query;
        @Nullable
        private Integer size;

        public Builder index(List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder typedKeys(@Nullable Boolean value) {
            this.typedKeys = value;
            return this;
        }

        public Builder aggs(@Nullable Map<String, Aggregation> value) {
            this.aggs = value;
            return this;
        }

        public Builder putAggs(String key, Aggregation value) {
            if (this.aggs == null) {
                this.aggs = new HashMap<String, Aggregation>();
            }
            this.aggs.put(key, value);
            return this;
        }

        public Builder aggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggs(Collections.singletonMap(key, fn.apply(new Aggregation.Builder()).build()));
        }

        public Builder putAggs(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.putAggs(key, fn.apply(new Aggregation.Builder()).build());
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        public RollupSearchRequest build() {
            return new RollupSearchRequest(this);
        }
    }
}

