/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeUsage
implements JsonpSerializable {
    private final Map<String, Integer> restActions;
    private final String since;
    private final String timestamp;
    private final Map<String, JsonData> aggregations;
    public static final JsonpDeserializer<NodeUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeUsage::setupNodeUsageDeserializer, Builder::build);

    public NodeUsage(Builder builder) {
        this.restActions = ModelTypeHelper.unmodifiableNonNull(builder.restActions, "rest_actions");
        this.since = Objects.requireNonNull(builder.since, "since");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
        this.aggregations = ModelTypeHelper.unmodifiableNonNull(builder.aggregations, "aggregations");
    }

    public NodeUsage(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, Integer> restActions() {
        return this.restActions;
    }

    public String since() {
        return this.since;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public Map<String, JsonData> aggregations() {
        return this.aggregations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rest_actions");
        generator.writeStartObject();
        for (Map.Entry<String, Integer> entry : this.restActions.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write(entry.getValue().intValue());
        }
        generator.writeEnd();
        generator.writeKey("since");
        generator.write(this.since);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        generator.writeKey("aggregations");
        generator.writeStartObject();
        for (Map.Entry<String, Object> entry : this.aggregations.entrySet()) {
            generator.writeKey(entry.getKey());
            ((JsonData)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupNodeUsageDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::restActions, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "rest_actions", new String[0]);
        op.add(Builder::since, JsonpDeserializer.stringDeserializer(), "since", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", new String[0]);
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "aggregations", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeUsage> {
        private Map<String, Integer> restActions;
        private String since;
        private String timestamp;
        private Map<String, JsonData> aggregations;

        public Builder restActions(Map<String, Integer> value) {
            this.restActions = value;
            return this;
        }

        public Builder putRestActions(String key, Integer value) {
            if (this.restActions == null) {
                this.restActions = new HashMap<String, Integer>();
            }
            this.restActions.put(key, value);
            return this;
        }

        public Builder since(String value) {
            this.since = value;
            return this;
        }

        public Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        public Builder aggregations(Map<String, JsonData> value) {
            this.aggregations = value;
            return this;
        }

        public Builder putAggregations(String key, JsonData value) {
            if (this.aggregations == null) {
                this.aggregations = new HashMap<String, JsonData>();
            }
            this.aggregations.put(key, value);
            return this;
        }

        @Override
        public NodeUsage build() {
            return new NodeUsage(this);
        }
    }
}

