/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeInfoScript
implements JsonpSerializable {
    private final String allowedTypes;
    private final String disableMaxCompilationsRate;
    public static final JsonpDeserializer<NodeInfoScript> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoScript::setupNodeInfoScriptDeserializer, Builder::build);

    public NodeInfoScript(Builder builder) {
        this.allowedTypes = Objects.requireNonNull(builder.allowedTypes, "allowed_types");
        this.disableMaxCompilationsRate = Objects.requireNonNull(builder.disableMaxCompilationsRate, "disable_max_compilations_rate");
    }

    public NodeInfoScript(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String allowedTypes() {
        return this.allowedTypes;
    }

    public String disableMaxCompilationsRate() {
        return this.disableMaxCompilationsRate;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allowed_types");
        generator.write(this.allowedTypes);
        generator.writeKey("disable_max_compilations_rate");
        generator.write(this.disableMaxCompilationsRate);
    }

    protected static void setupNodeInfoScriptDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allowedTypes, JsonpDeserializer.stringDeserializer(), "allowed_types", new String[0]);
        op.add(Builder::disableMaxCompilationsRate, JsonpDeserializer.stringDeserializer(), "disable_max_compilations_rate", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoScript> {
        private String allowedTypes;
        private String disableMaxCompilationsRate;

        public Builder allowedTypes(String value) {
            this.allowedTypes = value;
            return this;
        }

        public Builder disableMaxCompilationsRate(String value) {
            this.disableMaxCompilationsRate = value;
            return this;
        }

        @Override
        public NodeInfoScript build() {
            return new NodeInfoScript(this);
        }
    }
}

