/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Http
implements JsonpSerializable {
    private final int currentOpen;
    private final long totalOpened;
    public static final JsonpDeserializer<Http> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Http::setupHttpDeserializer, Builder::build);

    public Http(Builder builder) {
        this.currentOpen = Objects.requireNonNull(builder.currentOpen, "current_open");
        this.totalOpened = Objects.requireNonNull(builder.totalOpened, "total_opened");
    }

    public Http(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int currentOpen() {
        return this.currentOpen;
    }

    public long totalOpened() {
        return this.totalOpened;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current_open");
        generator.write(this.currentOpen);
        generator.writeKey("total_opened");
        generator.write(this.totalOpened);
    }

    protected static void setupHttpDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::currentOpen, JsonpDeserializer.integerDeserializer(), "current_open", new String[0]);
        op.add(Builder::totalOpened, JsonpDeserializer.longDeserializer(), "total_opened", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Http> {
        private Integer currentOpen;
        private Long totalOpened;

        public Builder currentOpen(int value) {
            this.currentOpen = value;
            return this;
        }

        public Builder totalOpened(long value) {
            this.totalOpened = value;
            return this;
        }

        @Override
        public Http build() {
            return new Http(this);
        }
    }
}

