/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.DataPathStats;
import co.elastic.clients.elasticsearch.nodes.FileSystemTotal;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FileSystem
implements JsonpSerializable {
    private final List<DataPathStats> data;
    private final long timestamp;
    private final FileSystemTotal total;
    public static final JsonpDeserializer<FileSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileSystem::setupFileSystemDeserializer, Builder::build);

    public FileSystem(Builder builder) {
        this.data = ModelTypeHelper.unmodifiableNonNull(builder.data, "data");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
        this.total = Objects.requireNonNull(builder.total, "total");
    }

    public FileSystem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<DataPathStats> data() {
        return this.data;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public FileSystemTotal total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("data");
        generator.writeStartArray();
        for (DataPathStats item0 : this.data) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
    }

    protected static void setupFileSystemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::data, JsonpDeserializer.arrayDeserializer(DataPathStats._DESERIALIZER), "data", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp", new String[0]);
        op.add(Builder::total, FileSystemTotal._DESERIALIZER, "total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FileSystem> {
        private List<DataPathStats> data;
        private Long timestamp;
        private FileSystemTotal total;

        public Builder data(List<DataPathStats> value) {
            this.data = value;
            return this;
        }

        public Builder data(DataPathStats ... value) {
            this.data = Arrays.asList(value);
            return this;
        }

        public Builder addData(DataPathStats value) {
            if (this.data == null) {
                this.data = new ArrayList<DataPathStats>();
            }
            this.data.add(value);
            return this;
        }

        public Builder data(Function<DataPathStats.Builder, ObjectBuilder<DataPathStats>> fn) {
            return this.data(fn.apply(new DataPathStats.Builder()).build());
        }

        public Builder addData(Function<DataPathStats.Builder, ObjectBuilder<DataPathStats>> fn) {
            return this.addData(fn.apply(new DataPathStats.Builder()).build());
        }

        public Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        public Builder total(FileSystemTotal value) {
            this.total = value;
            return this;
        }

        public Builder total(Function<FileSystemTotal.Builder, ObjectBuilder<FileSystemTotal>> fn) {
            return this.total(fn.apply(new FileSystemTotal.Builder()).build());
        }

        @Override
        public FileSystem build() {
            return new FileSystem(this);
        }
    }
}

