/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AdaptiveSelection
implements JsonpSerializable {
    private final long avgQueueSize;
    private final long avgResponseTime;
    private final long avgResponseTimeNs;
    private final String avgServiceTime;
    private final long avgServiceTimeNs;
    private final long outgoingSearches;
    private final String rank;
    public static final JsonpDeserializer<AdaptiveSelection> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AdaptiveSelection::setupAdaptiveSelectionDeserializer, Builder::build);

    public AdaptiveSelection(Builder builder) {
        this.avgQueueSize = Objects.requireNonNull(builder.avgQueueSize, "avg_queue_size");
        this.avgResponseTime = Objects.requireNonNull(builder.avgResponseTime, "avg_response_time");
        this.avgResponseTimeNs = Objects.requireNonNull(builder.avgResponseTimeNs, "avg_response_time_ns");
        this.avgServiceTime = Objects.requireNonNull(builder.avgServiceTime, "avg_service_time");
        this.avgServiceTimeNs = Objects.requireNonNull(builder.avgServiceTimeNs, "avg_service_time_ns");
        this.outgoingSearches = Objects.requireNonNull(builder.outgoingSearches, "outgoing_searches");
        this.rank = Objects.requireNonNull(builder.rank, "rank");
    }

    public AdaptiveSelection(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long avgQueueSize() {
        return this.avgQueueSize;
    }

    public long avgResponseTime() {
        return this.avgResponseTime;
    }

    public long avgResponseTimeNs() {
        return this.avgResponseTimeNs;
    }

    public String avgServiceTime() {
        return this.avgServiceTime;
    }

    public long avgServiceTimeNs() {
        return this.avgServiceTimeNs;
    }

    public long outgoingSearches() {
        return this.outgoingSearches;
    }

    public String rank() {
        return this.rank;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("avg_queue_size");
        generator.write(this.avgQueueSize);
        generator.writeKey("avg_response_time");
        generator.write(this.avgResponseTime);
        generator.writeKey("avg_response_time_ns");
        generator.write(this.avgResponseTimeNs);
        generator.writeKey("avg_service_time");
        generator.write(this.avgServiceTime);
        generator.writeKey("avg_service_time_ns");
        generator.write(this.avgServiceTimeNs);
        generator.writeKey("outgoing_searches");
        generator.write(this.outgoingSearches);
        generator.writeKey("rank");
        generator.write(this.rank);
    }

    protected static void setupAdaptiveSelectionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::avgQueueSize, JsonpDeserializer.longDeserializer(), "avg_queue_size", new String[0]);
        op.add(Builder::avgResponseTime, JsonpDeserializer.longDeserializer(), "avg_response_time", new String[0]);
        op.add(Builder::avgResponseTimeNs, JsonpDeserializer.longDeserializer(), "avg_response_time_ns", new String[0]);
        op.add(Builder::avgServiceTime, JsonpDeserializer.stringDeserializer(), "avg_service_time", new String[0]);
        op.add(Builder::avgServiceTimeNs, JsonpDeserializer.longDeserializer(), "avg_service_time_ns", new String[0]);
        op.add(Builder::outgoingSearches, JsonpDeserializer.longDeserializer(), "outgoing_searches", new String[0]);
        op.add(Builder::rank, JsonpDeserializer.stringDeserializer(), "rank", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AdaptiveSelection> {
        private Long avgQueueSize;
        private Long avgResponseTime;
        private Long avgResponseTimeNs;
        private String avgServiceTime;
        private Long avgServiceTimeNs;
        private Long outgoingSearches;
        private String rank;

        public Builder avgQueueSize(long value) {
            this.avgQueueSize = value;
            return this;
        }

        public Builder avgResponseTime(long value) {
            this.avgResponseTime = value;
            return this;
        }

        public Builder avgResponseTimeNs(long value) {
            this.avgResponseTimeNs = value;
            return this;
        }

        public Builder avgServiceTime(String value) {
            this.avgServiceTime = value;
            return this;
        }

        public Builder avgServiceTimeNs(long value) {
            this.avgServiceTimeNs = value;
            return this;
        }

        public Builder outgoingSearches(long value) {
            this.outgoingSearches = value;
            return this;
        }

        public Builder rank(String value) {
            this.rank = value;
            return this;
        }

        @Override
        public AdaptiveSelection build() {
            return new AdaptiveSelection(this);
        }
    }
}

