/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.PostDataResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class PostDataRequest<TData>
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    @Nullable
    private final String resetEnd;
    @Nullable
    private final String resetStart;
    private final List<TData> data;
    @Nullable
    private final JsonpSerializer<TData> tDataSerializer;
    public static final Endpoint<PostDataRequest<?>, PostDataResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PostDataRequest, PostDataResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_data");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.resetEnd != null) {
            params.put("reset_end", request.resetEnd);
        }
        if (request.resetStart != null) {
            params.put("reset_start", request.resetStart);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PostDataResponse._DESERIALIZER);

    public PostDataRequest(Builder<TData> builder) {
        this.jobId = Objects.requireNonNull(((Builder)builder).jobId, "job_id");
        this.resetEnd = ((Builder)builder).resetEnd;
        this.resetStart = ((Builder)builder).resetStart;
        this.data = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).data, "_value_body");
        this.tDataSerializer = ((Builder)builder).tDataSerializer;
    }

    public PostDataRequest(Function<Builder<TData>, Builder<TData>> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public String resetEnd() {
        return this.resetEnd;
    }

    @Nullable
    public String resetStart() {
        return this.resetStart;
    }

    public List<TData> data() {
        return this.data;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (TData item0 : this.data) {
            JsonpUtils.serialize(item0, generator, this.tDataSerializer, mapper);
        }
        generator.writeEnd();
    }

    public static <TData> JsonpDeserializer<PostDataRequest<TData>> createPostDataRequestDeserializer(JsonpDeserializer<TData> tDataDeserializer) {
        JsonpDeserializer valueDeserializer = JsonpDeserializer.arrayDeserializer(tDataDeserializer);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().data((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder<TData>
    implements ObjectBuilder<PostDataRequest<TData>> {
        private String jobId;
        @Nullable
        private String resetEnd;
        @Nullable
        private String resetStart;
        private List<TData> data;
        @Nullable
        private JsonpSerializer<TData> tDataSerializer;

        public Builder<TData> jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder<TData> resetEnd(@Nullable String value) {
            this.resetEnd = value;
            return this;
        }

        public Builder<TData> resetStart(@Nullable String value) {
            this.resetStart = value;
            return this;
        }

        public Builder<TData> data(List<TData> value) {
            this.data = value;
            return this;
        }

        public Builder<TData> data(TData ... value) {
            this.data = Arrays.asList(value);
            return this;
        }

        public Builder<TData> addData(TData value) {
            if (this.data == null) {
                this.data = new ArrayList<TData>();
            }
            this.data.add(value);
            return this;
        }

        public Builder<TData> tDataSerializer(@Nullable JsonpSerializer<TData> value) {
            this.tDataSerializer = value;
            return this;
        }

        @Override
        public PostDataRequest<TData> build() {
            return new PostDataRequest(this);
        }
    }
}

