/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetTrainedModelsStatsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetTrainedModelsStatsRequest
extends RequestBase {
    @Nullable
    private final String modelId;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    public static final Endpoint<GetTrainedModelsStatsRequest, GetTrainedModelsStatsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetTrainedModelsStatsRequest, GetTrainedModelsStatsResponse>(request -> "GET", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (request.modelId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/_stats");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetTrainedModelsStatsResponse._DESERIALIZER);

    public GetTrainedModelsStatsRequest(Builder builder) {
        this.modelId = builder.modelId;
        this.allowNoMatch = builder.allowNoMatch;
        this.from = builder.from;
        this.size = builder.size;
    }

    public GetTrainedModelsStatsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String modelId() {
        return this.modelId;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    public static class Builder
    implements ObjectBuilder<GetTrainedModelsStatsRequest> {
        @Nullable
        private String modelId;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;

        public Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        public GetTrainedModelsStatsRequest build() {
            return new GetTrainedModelsStatsRequest(this);
        }
    }
}

