/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.BucketInfluencer;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetInfluencersResponse
implements JsonpSerializable {
    private final long count;
    private final List<BucketInfluencer> influencers;
    public static final JsonpDeserializer<GetInfluencersResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetInfluencersResponse::setupGetInfluencersResponseDeserializer, Builder::build);

    public GetInfluencersResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.influencers = ModelTypeHelper.unmodifiableNonNull(builder.influencers, "influencers");
    }

    public GetInfluencersResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public List<BucketInfluencer> influencers() {
        return this.influencers;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("influencers");
        generator.writeStartArray();
        for (BucketInfluencer item0 : this.influencers) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetInfluencersResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::influencers, JsonpDeserializer.arrayDeserializer(BucketInfluencer._DESERIALIZER), "influencers", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetInfluencersResponse> {
        private Long count;
        private List<BucketInfluencer> influencers;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder influencers(List<BucketInfluencer> value) {
            this.influencers = value;
            return this;
        }

        public Builder influencers(BucketInfluencer ... value) {
            this.influencers = Arrays.asList(value);
            return this;
        }

        public Builder addInfluencers(BucketInfluencer value) {
            if (this.influencers == null) {
                this.influencers = new ArrayList<BucketInfluencer>();
            }
            this.influencers.add(value);
            return this;
        }

        public Builder influencers(Function<BucketInfluencer.Builder, ObjectBuilder<BucketInfluencer>> fn) {
            return this.influencers(fn.apply(new BucketInfluencer.Builder()).build());
        }

        public Builder addInfluencers(Function<BucketInfluencer.Builder, ObjectBuilder<BucketInfluencer>> fn) {
            return this.addInfluencers(fn.apply(new BucketInfluencer.Builder()).build());
        }

        @Override
        public GetInfluencersResponse build() {
            return new GetInfluencersResponse(this);
        }
    }
}

