/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetCategoriesResponse;
import co.elastic.clients.elasticsearch.ml.Page;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetCategoriesRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    @Nullable
    private final String categoryId;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final String partitionFieldValue;
    @Nullable
    private final Page page;
    public static final JsonpDeserializer<GetCategoriesRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetCategoriesRequest::setupGetCategoriesRequestDeserializer, Builder::build);
    public static final Endpoint<GetCategoriesRequest, GetCategoriesResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetCategoriesRequest, GetCategoriesResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        int _categoryId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.categoryId() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/categories");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.categoryId, buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/categories");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.partitionFieldValue != null) {
            params.put("partition_field_value", request.partitionFieldValue);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetCategoriesResponse._DESERIALIZER);

    public GetCategoriesRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.categoryId = builder.categoryId;
        this.from = builder.from;
        this.size = builder.size;
        this.partitionFieldValue = builder.partitionFieldValue;
        this.page = builder.page;
    }

    public GetCategoriesRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public String categoryId() {
        return this.categoryId;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public String partitionFieldValue() {
        return this.partitionFieldValue;
    }

    @Nullable
    public Page page() {
        return this.page;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.page != null) {
            generator.writeKey("page");
            this.page.serialize(generator, mapper);
        }
    }

    protected static void setupGetCategoriesRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::page, Page._DESERIALIZER, "page", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetCategoriesRequest> {
        private String jobId;
        @Nullable
        private String categoryId;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private String partitionFieldValue;
        @Nullable
        private Page page;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder categoryId(@Nullable String value) {
            this.categoryId = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder partitionFieldValue(@Nullable String value) {
            this.partitionFieldValue = value;
            return this;
        }

        public Builder page(@Nullable Page value) {
            this.page = value;
            return this;
        }

        public Builder page(Function<Page.Builder, ObjectBuilder<Page>> fn) {
            return this.page(fn.apply(new Page.Builder()).build());
        }

        @Override
        public GetCategoriesRequest build() {
            return new GetCategoriesRequest(this);
        }
    }
}

