/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeClassificationSummary;
import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeOutlierDetectionSummary;
import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeRegressionSummary;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class EvaluateDataFrameResponse
implements JsonpSerializable {
    @Nullable
    private final DataframeClassificationSummary classification;
    @Nullable
    private final DataframeOutlierDetectionSummary outlierDetection;
    @Nullable
    private final DataframeRegressionSummary regression;
    public static final JsonpDeserializer<EvaluateDataFrameResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EvaluateDataFrameResponse::setupEvaluateDataFrameResponseDeserializer, Builder::build);

    public EvaluateDataFrameResponse(Builder builder) {
        this.classification = builder.classification;
        this.outlierDetection = builder.outlierDetection;
        this.regression = builder.regression;
    }

    public EvaluateDataFrameResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public DataframeClassificationSummary classification() {
        return this.classification;
    }

    @Nullable
    public DataframeOutlierDetectionSummary outlierDetection() {
        return this.outlierDetection;
    }

    @Nullable
    public DataframeRegressionSummary regression() {
        return this.regression;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.classification != null) {
            generator.writeKey("classification");
            this.classification.serialize(generator, mapper);
        }
        if (this.outlierDetection != null) {
            generator.writeKey("outlier_detection");
            this.outlierDetection.serialize(generator, mapper);
        }
        if (this.regression != null) {
            generator.writeKey("regression");
            this.regression.serialize(generator, mapper);
        }
    }

    protected static void setupEvaluateDataFrameResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::classification, DataframeClassificationSummary._DESERIALIZER, "classification", new String[0]);
        op.add(Builder::outlierDetection, DataframeOutlierDetectionSummary._DESERIALIZER, "outlier_detection", new String[0]);
        op.add(Builder::regression, DataframeRegressionSummary._DESERIALIZER, "regression", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<EvaluateDataFrameResponse> {
        @Nullable
        private DataframeClassificationSummary classification;
        @Nullable
        private DataframeOutlierDetectionSummary outlierDetection;
        @Nullable
        private DataframeRegressionSummary regression;

        public Builder classification(@Nullable DataframeClassificationSummary value) {
            this.classification = value;
            return this;
        }

        public Builder classification(Function<DataframeClassificationSummary.Builder, ObjectBuilder<DataframeClassificationSummary>> fn) {
            return this.classification(fn.apply(new DataframeClassificationSummary.Builder()).build());
        }

        public Builder outlierDetection(@Nullable DataframeOutlierDetectionSummary value) {
            this.outlierDetection = value;
            return this;
        }

        public Builder outlierDetection(Function<DataframeOutlierDetectionSummary.Builder, ObjectBuilder<DataframeOutlierDetectionSummary>> fn) {
            return this.outlierDetection(fn.apply(new DataframeOutlierDetectionSummary.Builder()).build());
        }

        public Builder regression(@Nullable DataframeRegressionSummary value) {
            this.regression = value;
            return this;
        }

        public Builder regression(Function<DataframeRegressionSummary.Builder, ObjectBuilder<DataframeRegressionSummary>> fn) {
            return this.regression(fn.apply(new DataframeRegressionSummary.Builder()).build());
        }

        @Override
        public EvaluateDataFrameResponse build() {
            return new EvaluateDataFrameResponse(this);
        }
    }
}

