/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeEvaluationClassificationMetricsAucRoc;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class DataframeEvaluationMetrics
implements JsonpSerializable {
    @Nullable
    private final DataframeEvaluationClassificationMetricsAucRoc aucRoc;
    @Nullable
    private final Map<String, JsonData> precision;
    @Nullable
    private final Map<String, JsonData> recall;

    public DataframeEvaluationMetrics(AbstractBuilder<?> builder) {
        this.aucRoc = ((AbstractBuilder)builder).aucRoc;
        this.precision = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).precision);
        this.recall = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).recall);
    }

    @Nullable
    public DataframeEvaluationClassificationMetricsAucRoc aucRoc() {
        return this.aucRoc;
    }

    @Nullable
    public Map<String, JsonData> precision() {
        return this.precision;
    }

    @Nullable
    public Map<String, JsonData> recall() {
        return this.recall;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aucRoc != null) {
            generator.writeKey("auc_roc");
            this.aucRoc.serialize(generator, mapper);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.precision.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.recall != null) {
            generator.writeKey("recall");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.recall.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupDataframeEvaluationMetricsDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::aucRoc, DataframeEvaluationClassificationMetricsAucRoc._DESERIALIZER, "auc_roc", new String[0]);
        op.add(AbstractBuilder::precision, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "precision", new String[0]);
        op.add(AbstractBuilder::recall, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "recall", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private DataframeEvaluationClassificationMetricsAucRoc aucRoc;
        @Nullable
        private Map<String, JsonData> precision;
        @Nullable
        private Map<String, JsonData> recall;

        protected AbstractBuilder() {
        }

        public BuilderT aucRoc(@Nullable DataframeEvaluationClassificationMetricsAucRoc value) {
            this.aucRoc = value;
            return this.self();
        }

        public BuilderT aucRoc(Function<DataframeEvaluationClassificationMetricsAucRoc.Builder, ObjectBuilder<DataframeEvaluationClassificationMetricsAucRoc>> fn) {
            return this.aucRoc(fn.apply(new DataframeEvaluationClassificationMetricsAucRoc.Builder()).build());
        }

        public BuilderT precision(@Nullable Map<String, JsonData> value) {
            this.precision = value;
            return this.self();
        }

        public BuilderT putPrecision(String key, JsonData value) {
            if (this.precision == null) {
                this.precision = new HashMap<String, JsonData>();
            }
            this.precision.put(key, value);
            return this.self();
        }

        public BuilderT recall(@Nullable Map<String, JsonData> value) {
            this.recall = value;
            return this.self();
        }

        public BuilderT putRecall(String key, JsonData value) {
            if (this.recall == null) {
                this.recall = new HashMap<String, JsonData>();
            }
            this.recall.put(key, value);
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

