/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DataframeAnalysisFeatureProcessorTargetMeanEncoding
implements DataframeAnalysisFeatureProcessorVariant,
JsonpSerializable {
    private final int defaultValue;
    private final String featureName;
    private final String field;
    private final Map<String, JsonData> targetMap;
    public static final JsonpDeserializer<DataframeAnalysisFeatureProcessorTargetMeanEncoding> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalysisFeatureProcessorTargetMeanEncoding::setupDataframeAnalysisFeatureProcessorTargetMeanEncodingDeserializer, Builder::build);

    public DataframeAnalysisFeatureProcessorTargetMeanEncoding(Builder builder) {
        this.defaultValue = Objects.requireNonNull(builder.defaultValue, "default_value");
        this.featureName = Objects.requireNonNull(builder.featureName, "feature_name");
        this.field = Objects.requireNonNull(builder.field, "field");
        this.targetMap = ModelTypeHelper.unmodifiableNonNull(builder.targetMap, "target_map");
    }

    public DataframeAnalysisFeatureProcessorTargetMeanEncoding(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "target_mean_encoding";
    }

    public int defaultValue() {
        return this.defaultValue;
    }

    public String featureName() {
        return this.featureName;
    }

    public String field() {
        return this.field;
    }

    public Map<String, JsonData> targetMap() {
        return this.targetMap;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("default_value");
        generator.write(this.defaultValue);
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("target_map");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> item0 : this.targetMap.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupDataframeAnalysisFeatureProcessorTargetMeanEncodingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::defaultValue, JsonpDeserializer.integerDeserializer(), "default_value", new String[0]);
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::targetMap, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "target_map", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeAnalysisFeatureProcessorTargetMeanEncoding> {
        private Integer defaultValue;
        private String featureName;
        private String field;
        private Map<String, JsonData> targetMap;

        public Builder defaultValue(int value) {
            this.defaultValue = value;
            return this;
        }

        public Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder targetMap(Map<String, JsonData> value) {
            this.targetMap = value;
            return this;
        }

        public Builder putTargetMap(String key, JsonData value) {
            if (this.targetMap == null) {
                this.targetMap = new HashMap<String, JsonData>();
            }
            this.targetMap.put(key, value);
            return this;
        }

        @Override
        public DataframeAnalysisFeatureProcessorTargetMeanEncoding build() {
            return new DataframeAnalysisFeatureProcessorTargetMeanEncoding(this);
        }
    }
}

