/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataframeAnalysisFeatureProcessorNGramEncoding
implements DataframeAnalysisFeatureProcessorVariant,
JsonpSerializable {
    @Nullable
    private final String featurePrefix;
    private final String field;
    @Nullable
    private final Integer length;
    private final List<Integer> nGrams;
    @Nullable
    private final Integer start;
    @Nullable
    private final Boolean custom;
    public static final JsonpDeserializer<DataframeAnalysisFeatureProcessorNGramEncoding> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalysisFeatureProcessorNGramEncoding::setupDataframeAnalysisFeatureProcessorNGramEncodingDeserializer, Builder::build);

    public DataframeAnalysisFeatureProcessorNGramEncoding(Builder builder) {
        this.featurePrefix = builder.featurePrefix;
        this.field = Objects.requireNonNull(builder.field, "field");
        this.length = builder.length;
        this.nGrams = ModelTypeHelper.unmodifiableNonNull(builder.nGrams, "n_grams");
        this.start = builder.start;
        this.custom = builder.custom;
    }

    public DataframeAnalysisFeatureProcessorNGramEncoding(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "n_gram_encoding";
    }

    @Nullable
    public String featurePrefix() {
        return this.featurePrefix;
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Integer length() {
        return this.length;
    }

    public List<Integer> nGrams() {
        return this.nGrams;
    }

    @Nullable
    public Integer start() {
        return this.start;
    }

    @Nullable
    public Boolean custom() {
        return this.custom;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.featurePrefix != null) {
            generator.writeKey("feature_prefix");
            generator.write(this.featurePrefix);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.length != null) {
            generator.writeKey("length");
            generator.write(this.length.intValue());
        }
        generator.writeKey("n_grams");
        generator.writeStartArray();
        for (Integer item0 : this.nGrams) {
            generator.write(item0.intValue());
        }
        generator.writeEnd();
        if (this.start != null) {
            generator.writeKey("start");
            generator.write(this.start.intValue());
        }
        if (this.custom != null) {
            generator.writeKey("custom");
            generator.write(this.custom.booleanValue());
        }
    }

    protected static void setupDataframeAnalysisFeatureProcessorNGramEncodingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::featurePrefix, JsonpDeserializer.stringDeserializer(), "feature_prefix", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::length, JsonpDeserializer.integerDeserializer(), "length", new String[0]);
        op.add(Builder::nGrams, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.integerDeserializer()), "n_grams", new String[0]);
        op.add(Builder::start, JsonpDeserializer.integerDeserializer(), "start", new String[0]);
        op.add(Builder::custom, JsonpDeserializer.booleanDeserializer(), "custom", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeAnalysisFeatureProcessorNGramEncoding> {
        @Nullable
        private String featurePrefix;
        private String field;
        @Nullable
        private Integer length;
        private List<Integer> nGrams;
        @Nullable
        private Integer start;
        @Nullable
        private Boolean custom;

        public Builder featurePrefix(@Nullable String value) {
            this.featurePrefix = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder length(@Nullable Integer value) {
            this.length = value;
            return this;
        }

        public Builder nGrams(List<Integer> value) {
            this.nGrams = value;
            return this;
        }

        public Builder nGrams(Integer ... value) {
            this.nGrams = Arrays.asList(value);
            return this;
        }

        public Builder addNGrams(Integer value) {
            if (this.nGrams == null) {
                this.nGrams = new ArrayList<Integer>();
            }
            this.nGrams.add(value);
            return this;
        }

        public Builder start(@Nullable Integer value) {
            this.start = value;
            return this;
        }

        public Builder custom(@Nullable Boolean value) {
            this.custom = value;
            return this;
        }

        @Override
        public DataframeAnalysisFeatureProcessorNGramEncoding build() {
            return new DataframeAnalysisFeatureProcessorNGramEncoding(this);
        }
    }
}

