/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.PutPipelineResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutPipelineRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final Map<String, JsonData> meta;
    @Nullable
    private final String description;
    @Nullable
    private final List<Processor> onFailure;
    @Nullable
    private final List<Processor> processors;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<PutPipelineRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutPipelineRequest::setupPutPipelineRequestDeserializer, Builder::build);
    public static final Endpoint<PutPipelineRequest, PutPipelineResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutPipelineRequest, PutPipelineResponse>(request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/pipeline");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutPipelineResponse._DESERIALIZER);

    public PutPipelineRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.meta = ModelTypeHelper.unmodifiable(builder.meta);
        this.description = builder.description;
        this.onFailure = ModelTypeHelper.unmodifiable(builder.onFailure);
        this.processors = ModelTypeHelper.unmodifiable(builder.processors);
        this.version = builder.version;
    }

    public PutPipelineRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public List<Processor> onFailure() {
        return this.onFailure;
    }

    @Nullable
    public List<Processor> processors() {
        return this.processors;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.meta != null) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.onFailure != null) {
            generator.writeKey("on_failure");
            generator.writeStartArray();
            for (Processor processor : this.onFailure) {
                processor.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.processors != null) {
            generator.writeKey("processors");
            generator.writeStartArray();
            for (Processor processor : this.processors) {
                processor.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    protected static void setupPutPipelineRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::onFailure, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "on_failure", new String[0]);
        op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "processors", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutPipelineRequest> {
        private String id;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private String description;
        @Nullable
        private List<Processor> onFailure;
        @Nullable
        private List<Processor> processors;
        @Nullable
        private Long version;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder meta(@Nullable Map<String, JsonData> value) {
            this.meta = value;
            return this;
        }

        public Builder putMeta(String key, JsonData value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, JsonData>();
            }
            this.meta.put(key, value);
            return this;
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder onFailure(@Nullable List<Processor> value) {
            this.onFailure = value;
            return this;
        }

        public Builder onFailure(Processor ... value) {
            this.onFailure = Arrays.asList(value);
            return this;
        }

        public Builder addOnFailure(Processor value) {
            if (this.onFailure == null) {
                this.onFailure = new ArrayList<Processor>();
            }
            this.onFailure.add(value);
            return this;
        }

        public Builder onFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.onFailure(fn.apply(new Processor.Builder()).build());
        }

        public Builder addOnFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.addOnFailure(fn.apply(new Processor.Builder()).build());
        }

        public Builder processors(@Nullable List<Processor> value) {
            this.processors = value;
            return this;
        }

        public Builder processors(Processor ... value) {
            this.processors = Arrays.asList(value);
            return this;
        }

        public Builder addProcessors(Processor value) {
            if (this.processors == null) {
                this.processors = new ArrayList<Processor>();
            }
            this.processors.add(value);
            return this;
        }

        public Builder processors(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.processors(fn.apply(new Processor.Builder()).build());
        }

        public Builder addProcessors(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.addProcessors(fn.apply(new Processor.Builder()).build());
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        public PutPipelineRequest build() {
            return new PutPipelineRequest(this);
        }
    }
}

