/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class JsonProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final boolean addToRoot;
    private final String field;
    private final String targetField;
    public static final JsonpDeserializer<JsonProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JsonProcessor::setupJsonProcessorDeserializer, Builder::build);

    public JsonProcessor(Builder builder) {
        super(builder);
        this.addToRoot = Objects.requireNonNull(builder.addToRoot, "add_to_root");
        this.field = Objects.requireNonNull(builder.field, "field");
        this.targetField = Objects.requireNonNull(builder.targetField, "target_field");
    }

    public JsonProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "json";
    }

    public boolean addToRoot() {
        return this.addToRoot;
    }

    public String field() {
        return this.field;
    }

    public String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("add_to_root");
        generator.write(this.addToRoot);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("target_field");
        generator.write(this.targetField);
    }

    protected static void setupJsonProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::addToRoot, JsonpDeserializer.booleanDeserializer(), "add_to_root", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<JsonProcessor> {
        private Boolean addToRoot;
        private String field;
        private String targetField;

        public Builder addToRoot(boolean value) {
            this.addToRoot = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JsonProcessor build() {
            return new JsonProcessor(this);
        }
    }
}

