/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.InferenceConfig;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class InferenceProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String modelId;
    private final String targetField;
    @Nullable
    private final Map<String, JsonData> fieldMap;
    @Nullable
    private final InferenceConfig inferenceConfig;
    public static final JsonpDeserializer<InferenceProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceProcessor::setupInferenceProcessorDeserializer, Builder::build);

    public InferenceProcessor(Builder builder) {
        super(builder);
        this.modelId = Objects.requireNonNull(builder.modelId, "model_id");
        this.targetField = Objects.requireNonNull(builder.targetField, "target_field");
        this.fieldMap = ModelTypeHelper.unmodifiable(builder.fieldMap);
        this.inferenceConfig = builder.inferenceConfig;
    }

    public InferenceProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "inference";
    }

    public String modelId() {
        return this.modelId;
    }

    public String targetField() {
        return this.targetField;
    }

    @Nullable
    public Map<String, JsonData> fieldMap() {
        return this.fieldMap;
    }

    @Nullable
    public InferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("target_field");
        generator.write(this.targetField);
        if (this.fieldMap != null) {
            generator.writeKey("field_map");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.fieldMap.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.inferenceConfig != null) {
            generator.writeKey("inference_config");
            this.inferenceConfig.serialize(generator, mapper);
        }
    }

    protected static void setupInferenceProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id", new String[0]);
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field", new String[0]);
        op.add(Builder::fieldMap, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "field_map", new String[0]);
        op.add(Builder::inferenceConfig, InferenceConfig._DESERIALIZER, "inference_config", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InferenceProcessor> {
        private String modelId;
        private String targetField;
        @Nullable
        private Map<String, JsonData> fieldMap;
        @Nullable
        private InferenceConfig inferenceConfig;

        public Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        public Builder fieldMap(@Nullable Map<String, JsonData> value) {
            this.fieldMap = value;
            return this;
        }

        public Builder putFieldMap(String key, JsonData value) {
            if (this.fieldMap == null) {
                this.fieldMap = new HashMap<String, JsonData>();
            }
            this.fieldMap.put(key, value);
            return this;
        }

        public Builder inferenceConfig(@Nullable InferenceConfig value) {
            this.inferenceConfig = value;
            return this;
        }

        public Builder inferenceConfig(Function<InferenceConfig.Builder, ObjectBuilder<InferenceConfig>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfig.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceProcessor build() {
            return new InferenceProcessor(this);
        }
    }
}

