/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FailProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String message;
    public static final JsonpDeserializer<FailProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FailProcessor::setupFailProcessorDeserializer, Builder::build);

    public FailProcessor(Builder builder) {
        super(builder);
        this.message = Objects.requireNonNull(builder.message, "message");
    }

    public FailProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "fail";
    }

    public String message() {
        return this.message;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("message");
        generator.write(this.message);
    }

    protected static void setupFailProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::message, JsonpDeserializer.stringDeserializer(), "message", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FailProcessor> {
        private String message;

        public Builder message(String value) {
            this.message = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FailProcessor build() {
            return new FailProcessor(this);
        }
    }
}

