/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DissectProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String appendSeparator;
    private final String field;
    private final boolean ignoreMissing;
    private final String pattern;
    public static final JsonpDeserializer<DissectProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DissectProcessor::setupDissectProcessorDeserializer, Builder::build);

    public DissectProcessor(Builder builder) {
        super(builder);
        this.appendSeparator = Objects.requireNonNull(builder.appendSeparator, "append_separator");
        this.field = Objects.requireNonNull(builder.field, "field");
        this.ignoreMissing = Objects.requireNonNull(builder.ignoreMissing, "ignore_missing");
        this.pattern = Objects.requireNonNull(builder.pattern, "pattern");
    }

    public DissectProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "dissect";
    }

    public String appendSeparator() {
        return this.appendSeparator;
    }

    public String field() {
        return this.field;
    }

    public boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public String pattern() {
        return this.pattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("append_separator");
        generator.write(this.appendSeparator);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("ignore_missing");
        generator.write(this.ignoreMissing);
        generator.writeKey("pattern");
        generator.write(this.pattern);
    }

    protected static void setupDissectProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::appendSeparator, JsonpDeserializer.stringDeserializer(), "append_separator", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DissectProcessor> {
        private String appendSeparator;
        private String field;
        private Boolean ignoreMissing;
        private String pattern;

        public Builder appendSeparator(String value) {
            this.appendSeparator = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DissectProcessor build() {
            return new DissectProcessor(this);
        }
    }
}

