/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_index_template;

import co.elastic.clients.elasticsearch.indices.get_index_template.IndexTemplate;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class IndexTemplateItem
implements JsonpSerializable {
    private final String name;
    private final IndexTemplate indexTemplate;
    public static final JsonpDeserializer<IndexTemplateItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexTemplateItem::setupIndexTemplateItemDeserializer, Builder::build);

    public IndexTemplateItem(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.indexTemplate = Objects.requireNonNull(builder.indexTemplate, "index_template");
    }

    public IndexTemplateItem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public IndexTemplate indexTemplate() {
        return this.indexTemplate;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("index_template");
        this.indexTemplate.serialize(generator, mapper);
    }

    protected static void setupIndexTemplateItemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::indexTemplate, IndexTemplate._DESERIALIZER, "index_template", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexTemplateItem> {
        private String name;
        private IndexTemplate indexTemplate;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder indexTemplate(IndexTemplate value) {
            this.indexTemplate = value;
            return this;
        }

        public Builder indexTemplate(Function<IndexTemplate.Builder, ObjectBuilder<IndexTemplate>> fn) {
            return this.indexTemplate(fn.apply(new IndexTemplate.Builder()).build());
        }

        @Override
        public IndexTemplateItem build() {
            return new IndexTemplateItem(this);
        }
    }
}

