/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TemplateMapping
implements JsonpSerializable {
    private final Map<String, Alias> aliases;
    private final List<String> indexPatterns;
    private final TypeMapping mappings;
    private final int order;
    private final Map<String, JsonData> settings;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<TemplateMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TemplateMapping::setupTemplateMappingDeserializer, Builder::build);

    public TemplateMapping(Builder builder) {
        this.aliases = ModelTypeHelper.unmodifiableNonNull(builder.aliases, "aliases");
        this.indexPatterns = ModelTypeHelper.unmodifiableNonNull(builder.indexPatterns, "index_patterns");
        this.mappings = Objects.requireNonNull(builder.mappings, "mappings");
        this.order = Objects.requireNonNull(builder.order, "order");
        this.settings = ModelTypeHelper.unmodifiableNonNull(builder.settings, "settings");
        this.version = builder.version;
    }

    public TemplateMapping(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, Alias> aliases() {
        return this.aliases;
    }

    public List<String> indexPatterns() {
        return this.indexPatterns;
    }

    public TypeMapping mappings() {
        return this.mappings;
    }

    public int order() {
        return this.order;
    }

    public Map<String, JsonData> settings() {
        return this.settings;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aliases");
        generator.writeStartObject();
        for (Map.Entry<String, Alias> entry : this.aliases.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("index_patterns");
        generator.writeStartArray();
        for (String string : this.indexPatterns) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
        generator.writeKey("order");
        generator.write(this.order);
        generator.writeKey("settings");
        generator.writeStartObject();
        for (Map.Entry entry : this.settings.entrySet()) {
            generator.writeKey((String)entry.getKey());
            ((JsonData)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    protected static void setupTemplateMappingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(Alias._DESERIALIZER), "aliases", new String[0]);
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns", new String[0]);
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings", new String[0]);
        op.add(Builder::order, JsonpDeserializer.integerDeserializer(), "order", new String[0]);
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "settings", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TemplateMapping> {
        private Map<String, Alias> aliases;
        private List<String> indexPatterns;
        private TypeMapping mappings;
        private Integer order;
        private Map<String, JsonData> settings;
        @Nullable
        private Long version;

        public Builder aliases(Map<String, Alias> value) {
            this.aliases = value;
            return this;
        }

        public Builder putAliases(String key, Alias value) {
            if (this.aliases == null) {
                this.aliases = new HashMap<String, Alias>();
            }
            this.aliases.put(key, value);
            return this;
        }

        public Builder aliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.aliases(Collections.singletonMap(key, fn.apply(new Alias.Builder()).build()));
        }

        public Builder putAliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.putAliases(key, fn.apply(new Alias.Builder()).build());
        }

        public Builder indexPatterns(List<String> value) {
            this.indexPatterns = value;
            return this;
        }

        public Builder indexPatterns(String ... value) {
            this.indexPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addIndexPatterns(String value) {
            if (this.indexPatterns == null) {
                this.indexPatterns = new ArrayList<String>();
            }
            this.indexPatterns.add(value);
            return this;
        }

        public Builder mappings(TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public Builder order(int value) {
            this.order = value;
            return this;
        }

        public Builder settings(Map<String, JsonData> value) {
            this.settings = value;
            return this;
        }

        public Builder putSettings(String key, JsonData value) {
            if (this.settings == null) {
                this.settings = new HashMap<String, JsonData>();
            }
            this.settings.put(key, value);
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        public TemplateMapping build() {
            return new TemplateMapping(this);
        }
    }
}

