/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.shard_stores.IndicesShardStores;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardStoresResponse
implements JsonpSerializable {
    private final Map<String, IndicesShardStores> indices;
    public static final JsonpDeserializer<ShardStoresResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStoresResponse::setupShardStoresResponseDeserializer, Builder::build);

    public ShardStoresResponse(Builder builder) {
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
    }

    public ShardStoresResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, IndicesShardStores> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.writeStartObject();
        for (Map.Entry<String, IndicesShardStores> item0 : this.indices.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupShardStoresResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(IndicesShardStores._DESERIALIZER), "indices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardStoresResponse> {
        private Map<String, IndicesShardStores> indices;

        public Builder indices(Map<String, IndicesShardStores> value) {
            this.indices = value;
            return this;
        }

        public Builder putIndices(String key, IndicesShardStores value) {
            if (this.indices == null) {
                this.indices = new HashMap<String, IndicesShardStores>();
            }
            this.indices.put(key, value);
            return this;
        }

        public Builder indices(String key, Function<IndicesShardStores.Builder, ObjectBuilder<IndicesShardStores>> fn) {
            return this.indices(Collections.singletonMap(key, fn.apply(new IndicesShardStores.Builder()).build()));
        }

        public Builder putIndices(String key, Function<IndicesShardStores.Builder, ObjectBuilder<IndicesShardStores>> fn) {
            return this.putIndices(key, fn.apply(new IndicesShardStores.Builder()).build());
        }

        @Override
        public ShardStoresResponse build() {
            return new ShardStoresResponse(this);
        }
    }
}

