/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.ResolveIndexResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ResolveIndexRequest
extends RequestBase {
    private final List<String> name;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    public static final Endpoint<ResolveIndexRequest, ResolveIndexResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ResolveIndexRequest, ResolveIndexResponse>(request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_resolve");
            buf.append("/index");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ResolveIndexResponse._DESERIALIZER);

    public ResolveIndexRequest(Builder builder) {
        this.name = ModelTypeHelper.unmodifiableNonNull(builder.name, "name");
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
    }

    public ResolveIndexRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> name() {
        return this.name;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    public static class Builder
    implements ObjectBuilder<ResolveIndexRequest> {
        private List<String> name;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;

        public Builder name(List<String> value) {
            this.name = value;
            return this;
        }

        public Builder name(String ... value) {
            this.name = Arrays.asList(value);
            return this;
        }

        public Builder addName(String value) {
            if (this.name == null) {
                this.name = new ArrayList<String>();
            }
            this.name.add(value);
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        @Override
        public ResolveIndexRequest build() {
            return new ResolveIndexRequest(this);
        }
    }
}

