/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.elasticsearch.indices.close.CloseIndexResult;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class CloseIndexResponse
extends AcknowledgedResponseBase {
    private final Map<String, CloseIndexResult> indices;
    private final boolean shardsAcknowledged;
    public static final JsonpDeserializer<CloseIndexResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloseIndexResponse::setupCloseIndexResponseDeserializer, Builder::build);

    public CloseIndexResponse(Builder builder) {
        super(builder);
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.shardsAcknowledged = Objects.requireNonNull(builder.shardsAcknowledged, "shards_acknowledged");
    }

    public CloseIndexResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, CloseIndexResult> indices() {
        return this.indices;
    }

    public boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("indices");
        generator.writeStartObject();
        for (Map.Entry<String, CloseIndexResult> item0 : this.indices.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
    }

    protected static void setupCloseIndexResponseDeserializer(DelegatingDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(CloseIndexResult._DESERIALIZER), "indices", new String[0]);
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged", new String[0]);
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CloseIndexResponse> {
        private Map<String, CloseIndexResult> indices;
        private Boolean shardsAcknowledged;

        public Builder indices(Map<String, CloseIndexResult> value) {
            this.indices = value;
            return this;
        }

        public Builder putIndices(String key, CloseIndexResult value) {
            if (this.indices == null) {
                this.indices = new HashMap<String, CloseIndexResult>();
            }
            this.indices.put(key, value);
            return this;
        }

        public Builder indices(String key, Function<CloseIndexResult.Builder, ObjectBuilder<CloseIndexResult>> fn) {
            return this.indices(Collections.singletonMap(key, fn.apply(new CloseIndexResult.Builder()).build()));
        }

        public Builder putIndices(String key, Function<CloseIndexResult.Builder, ObjectBuilder<CloseIndexResult>> fn) {
            return this.putIndices(key, fn.apply(new CloseIndexResult.Builder()).build());
        }

        public Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CloseIndexResponse build() {
            return new CloseIndexResponse(this);
        }
    }
}

