/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RemovePolicyResponse
implements JsonpSerializable {
    private final List<String> failedIndexes;
    private final boolean hasFailures;
    public static final JsonpDeserializer<RemovePolicyResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemovePolicyResponse::setupRemovePolicyResponseDeserializer, Builder::build);

    public RemovePolicyResponse(Builder builder) {
        this.failedIndexes = ModelTypeHelper.unmodifiableNonNull(builder.failedIndexes, "failed_indexes");
        this.hasFailures = Objects.requireNonNull(builder.hasFailures, "has_failures");
    }

    public RemovePolicyResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> failedIndexes() {
        return this.failedIndexes;
    }

    public boolean hasFailures() {
        return this.hasFailures;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("failed_indexes");
        generator.writeStartArray();
        for (String item0 : this.failedIndexes) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("has_failures");
        generator.write(this.hasFailures);
    }

    protected static void setupRemovePolicyResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::failedIndexes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "failed_indexes", new String[0]);
        op.add(Builder::hasFailures, JsonpDeserializer.booleanDeserializer(), "has_failures", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RemovePolicyResponse> {
        private List<String> failedIndexes;
        private Boolean hasFailures;

        public Builder failedIndexes(List<String> value) {
            this.failedIndexes = value;
            return this;
        }

        public Builder failedIndexes(String ... value) {
            this.failedIndexes = Arrays.asList(value);
            return this;
        }

        public Builder addFailedIndexes(String value) {
            if (this.failedIndexes == null) {
                this.failedIndexes = new ArrayList<String>();
            }
            this.failedIndexes.add(value);
            return this;
        }

        public Builder hasFailures(boolean value) {
            this.hasFailures = value;
            return this;
        }

        @Override
        public RemovePolicyResponse build() {
            return new RemovePolicyResponse(this);
        }
    }
}

