/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.elasticsearch.graph.SampleDiversity;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ExploreControls
implements JsonpSerializable {
    @Nullable
    private final SampleDiversity sampleDiversity;
    @Nullable
    private final Integer sampleSize;
    @Nullable
    private final String timeout;
    private final boolean useSignificance;
    public static final JsonpDeserializer<ExploreControls> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExploreControls::setupExploreControlsDeserializer, Builder::build);

    public ExploreControls(Builder builder) {
        this.sampleDiversity = builder.sampleDiversity;
        this.sampleSize = builder.sampleSize;
        this.timeout = builder.timeout;
        this.useSignificance = Objects.requireNonNull(builder.useSignificance, "use_significance");
    }

    public ExploreControls(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public SampleDiversity sampleDiversity() {
        return this.sampleDiversity;
    }

    @Nullable
    public Integer sampleSize() {
        return this.sampleSize;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public boolean useSignificance() {
        return this.useSignificance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.sampleDiversity != null) {
            generator.writeKey("sample_diversity");
            this.sampleDiversity.serialize(generator, mapper);
        }
        if (this.sampleSize != null) {
            generator.writeKey("sample_size");
            generator.write(this.sampleSize.intValue());
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            generator.write(this.timeout);
        }
        generator.writeKey("use_significance");
        generator.write(this.useSignificance);
    }

    protected static void setupExploreControlsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::sampleDiversity, SampleDiversity._DESERIALIZER, "sample_diversity", new String[0]);
        op.add(Builder::sampleSize, JsonpDeserializer.integerDeserializer(), "sample_size", new String[0]);
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout", new String[0]);
        op.add(Builder::useSignificance, JsonpDeserializer.booleanDeserializer(), "use_significance", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExploreControls> {
        @Nullable
        private SampleDiversity sampleDiversity;
        @Nullable
        private Integer sampleSize;
        @Nullable
        private String timeout;
        private Boolean useSignificance;

        public Builder sampleDiversity(@Nullable SampleDiversity value) {
            this.sampleDiversity = value;
            return this;
        }

        public Builder sampleDiversity(Function<SampleDiversity.Builder, ObjectBuilder<SampleDiversity>> fn) {
            return this.sampleDiversity(fn.apply(new SampleDiversity.Builder()).build());
        }

        public Builder sampleSize(@Nullable Integer value) {
            this.sampleSize = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder useSignificance(boolean value) {
            this.useSignificance = value;
            return this;
        }

        @Override
        public ExploreControls build() {
            return new ExploreControls(this);
        }
    }
}

