/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.eql.EqlGetResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class EqlGetRequest
extends RequestBase {
    private final String id;
    @Nullable
    private final String keepAlive;
    @Nullable
    private final String waitForCompletionTimeout;
    private static final SimpleEndpoint<EqlGetRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_eql");
            buf.append("/search");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.keepAlive != null) {
            params.put("keep_alive", request.keepAlive);
        }
        if (request.waitForCompletionTimeout != null) {
            params.put("wait_for_completion_timeout", request.waitForCompletionTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, null);

    public EqlGetRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.keepAlive = builder.keepAlive;
        this.waitForCompletionTimeout = builder.waitForCompletionTimeout;
    }

    public EqlGetRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public String waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public static <TEvent> Endpoint<EqlGetRequest, EqlGetResponse<TEvent>, ElasticsearchError> createGetEndpoint(JsonpDeserializer<TEvent> tEventDeserializer) {
        return ENDPOINT.withResponseDeserializer(EqlGetResponse.createEqlGetResponseDeserializer(tEventDeserializer));
    }

    public static class Builder
    implements ObjectBuilder<EqlGetRequest> {
        private String id;
        @Nullable
        private String keepAlive;
        @Nullable
        private String waitForCompletionTimeout;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder keepAlive(@Nullable String value) {
            this.keepAlive = value;
            return this;
        }

        public Builder waitForCompletionTimeout(@Nullable String value) {
            this.waitForCompletionTimeout = value;
            return this;
        }

        @Override
        public EqlGetRequest build() {
            return new EqlGetRequest(this);
        }
    }
}

