/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.enrich.ExecutePolicyResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ExecutePolicyRequest
extends RequestBase {
    private final String name;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<ExecutePolicyRequest, ExecutePolicyResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ExecutePolicyRequest, ExecutePolicyResponse>(request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_enrich");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            buf.append("/_execute");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ExecutePolicyResponse._DESERIALIZER);

    public ExecutePolicyRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.waitForCompletion = builder.waitForCompletion;
    }

    public ExecutePolicyRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public static class Builder
    implements ObjectBuilder<ExecutePolicyRequest> {
        private String name;
        @Nullable
        private Boolean waitForCompletion;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        public ExecutePolicyRequest build() {
            return new ExecutePolicyRequest(this);
        }
    }
}

