/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.dangling_indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.dangling_indices.DeleteDanglingIndexResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteDanglingIndexRequest
extends RequestBase {
    private final String indexUuid;
    private final boolean acceptDataLoss;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    public static final Endpoint<DeleteDanglingIndexRequest, DeleteDanglingIndexResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteDanglingIndexRequest, DeleteDanglingIndexResponse>(request -> "DELETE", request -> {
        boolean _indexUuid = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_dangling");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexUuid, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accept_data_loss", String.valueOf(request.acceptDataLoss));
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteDanglingIndexResponse._DESERIALIZER);

    public DeleteDanglingIndexRequest(Builder builder) {
        this.indexUuid = Objects.requireNonNull(builder.indexUuid, "index_uuid");
        this.acceptDataLoss = Objects.requireNonNull(builder.acceptDataLoss, "accept_data_loss");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
    }

    public DeleteDanglingIndexRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String indexUuid() {
        return this.indexUuid;
    }

    public boolean acceptDataLoss() {
        return this.acceptDataLoss;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<DeleteDanglingIndexRequest> {
        private String indexUuid;
        private Boolean acceptDataLoss;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;

        public Builder indexUuid(String value) {
            this.indexUuid = value;
            return this;
        }

        public Builder acceptDataLoss(boolean value) {
            this.acceptDataLoss = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public DeleteDanglingIndexRequest build() {
            return new DeleteDanglingIndexRequest(this);
        }
    }
}

