/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.termvectors;

import co.elastic.clients.elasticsearch.core.termvectors.Token;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Term
implements JsonpSerializable {
    @Nullable
    private final Integer docFreq;
    @Nullable
    private final Double score;
    private final int termFreq;
    private final List<Token> tokens;
    @Nullable
    private final Integer ttf;
    public static final JsonpDeserializer<Term> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Term::setupTermDeserializer, Builder::build);

    public Term(Builder builder) {
        this.docFreq = builder.docFreq;
        this.score = builder.score;
        this.termFreq = Objects.requireNonNull(builder.termFreq, "term_freq");
        this.tokens = ModelTypeHelper.unmodifiableNonNull(builder.tokens, "tokens");
        this.ttf = builder.ttf;
    }

    public Term(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Integer docFreq() {
        return this.docFreq;
    }

    @Nullable
    public Double score() {
        return this.score;
    }

    public int termFreq() {
        return this.termFreq;
    }

    public List<Token> tokens() {
        return this.tokens;
    }

    @Nullable
    public Integer ttf() {
        return this.ttf;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.docFreq != null) {
            generator.writeKey("doc_freq");
            generator.write(this.docFreq.intValue());
        }
        if (this.score != null) {
            generator.writeKey("score");
            generator.write(this.score.doubleValue());
        }
        generator.writeKey("term_freq");
        generator.write(this.termFreq);
        generator.writeKey("tokens");
        generator.writeStartArray();
        for (Token item0 : this.tokens) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.ttf != null) {
            generator.writeKey("ttf");
            generator.write(this.ttf.intValue());
        }
    }

    protected static void setupTermDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::docFreq, JsonpDeserializer.integerDeserializer(), "doc_freq", new String[0]);
        op.add(Builder::score, JsonpDeserializer.doubleDeserializer(), "score", new String[0]);
        op.add(Builder::termFreq, JsonpDeserializer.integerDeserializer(), "term_freq", new String[0]);
        op.add(Builder::tokens, JsonpDeserializer.arrayDeserializer(Token._DESERIALIZER), "tokens", new String[0]);
        op.add(Builder::ttf, JsonpDeserializer.integerDeserializer(), "ttf", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Term> {
        @Nullable
        private Integer docFreq;
        @Nullable
        private Double score;
        private Integer termFreq;
        private List<Token> tokens;
        @Nullable
        private Integer ttf;

        public Builder docFreq(@Nullable Integer value) {
            this.docFreq = value;
            return this;
        }

        public Builder score(@Nullable Double value) {
            this.score = value;
            return this;
        }

        public Builder termFreq(int value) {
            this.termFreq = value;
            return this;
        }

        public Builder tokens(List<Token> value) {
            this.tokens = value;
            return this;
        }

        public Builder tokens(Token ... value) {
            this.tokens = Arrays.asList(value);
            return this;
        }

        public Builder addTokens(Token value) {
            if (this.tokens == null) {
                this.tokens = new ArrayList<Token>();
            }
            this.tokens.add(value);
            return this;
        }

        public Builder tokens(Function<Token.Builder, ObjectBuilder<Token>> fn) {
            return this.tokens(fn.apply(new Token.Builder()).build());
        }

        public Builder addTokens(Function<Token.Builder, ObjectBuilder<Token>> fn) {
            return this.addTokens(fn.apply(new Token.Builder()).build());
        }

        public Builder ttf(@Nullable Integer value) {
            this.ttf = value;
            return this;
        }

        @Override
        public Term build() {
            return new Term(this);
        }
    }
}

