/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search_shards;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ShardStoreIndex
implements JsonpSerializable {
    @Nullable
    private final List<String> aliases;
    @Nullable
    private final Query filter;
    public static final JsonpDeserializer<ShardStoreIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStoreIndex::setupShardStoreIndexDeserializer, Builder::build);

    public ShardStoreIndex(Builder builder) {
        this.aliases = ModelTypeHelper.unmodifiable(builder.aliases);
        this.filter = builder.filter;
    }

    public ShardStoreIndex(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> aliases() {
        return this.aliases;
    }

    @Nullable
    public Query filter() {
        return this.filter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.aliases != null) {
            generator.writeKey("aliases");
            generator.writeStartArray();
            for (String item0 : this.aliases) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
    }

    protected static void setupShardStoreIndexDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "aliases", new String[0]);
        op.add(Builder::filter, Query._DESERIALIZER, "filter", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardStoreIndex> {
        @Nullable
        private List<String> aliases;
        @Nullable
        private Query filter;

        public Builder aliases(@Nullable List<String> value) {
            this.aliases = value;
            return this;
        }

        public Builder aliases(String ... value) {
            this.aliases = Arrays.asList(value);
            return this;
        }

        public Builder addAliases(String value) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            this.aliases.add(value);
            return this;
        }

        public Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        @Override
        public ShardStoreIndex build() {
            return new ShardStoreIndex(this);
        }
    }
}

