/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.LaplaceSmoothingModel;
import co.elastic.clients.elasticsearch.core.search.LinearInterpolationSmoothingModel;
import co.elastic.clients.elasticsearch.core.search.SmoothingModelVariant;
import co.elastic.clients.elasticsearch.core.search.StupidBackoffSmoothingModel;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class SmoothingModel
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String LAPLACE = "laplace";
    public static final String LINEAR_INTERPOLATION = "linear_interpolation";
    public static final String STUPID_BACKOFF = "stupid_backoff";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<SmoothingModel> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, SmoothingModel::setupSmoothingModelDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public SmoothingModel(SmoothingModelVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends SmoothingModelVariant> SmoothingModel(ObjectBuilder<T> builder) {
        this((SmoothingModelVariant)builder.build());
    }

    private SmoothingModel(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public SmoothingModel(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public LaplaceSmoothingModel laplace() {
        return (LaplaceSmoothingModel)TaggedUnionUtils.get(this, LAPLACE);
    }

    public LinearInterpolationSmoothingModel linearInterpolation() {
        return (LinearInterpolationSmoothingModel)TaggedUnionUtils.get(this, LINEAR_INTERPOLATION);
    }

    public StupidBackoffSmoothingModel stupidBackoff() {
        return (StupidBackoffSmoothingModel)TaggedUnionUtils.get(this, STUPID_BACKOFF);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupSmoothingModelDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::laplace, LaplaceSmoothingModel._DESERIALIZER, LAPLACE, new String[0]);
        op.add(Builder::linearInterpolation, LinearInterpolationSmoothingModel._DESERIALIZER, LINEAR_INTERPOLATION, new String[0]);
        op.add(Builder::stupidBackoff, StupidBackoffSmoothingModel._DESERIALIZER, STUPID_BACKOFF, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SmoothingModel> {
        private String _type;
        private Object _value;

        public Builder laplace(LaplaceSmoothingModel v) {
            this._type = SmoothingModel.LAPLACE;
            this._value = v;
            return this;
        }

        public Builder laplace(Function<LaplaceSmoothingModel.Builder, ObjectBuilder<LaplaceSmoothingModel>> f) {
            return this.laplace(f.apply(new LaplaceSmoothingModel.Builder()).build());
        }

        public Builder linearInterpolation(LinearInterpolationSmoothingModel v) {
            this._type = SmoothingModel.LINEAR_INTERPOLATION;
            this._value = v;
            return this;
        }

        public Builder linearInterpolation(Function<LinearInterpolationSmoothingModel.Builder, ObjectBuilder<LinearInterpolationSmoothingModel>> f) {
            return this.linearInterpolation(f.apply(new LinearInterpolationSmoothingModel.Builder()).build());
        }

        public Builder stupidBackoff(StupidBackoffSmoothingModel v) {
            this._type = SmoothingModel.STUPID_BACKOFF;
            this._value = v;
            return this;
        }

        public Builder stupidBackoff(Function<StupidBackoffSmoothingModel.Builder, ObjectBuilder<StupidBackoffSmoothingModel>> f) {
            return this.stupidBackoff(f.apply(new StupidBackoffSmoothingModel.Builder()).build());
        }

        @Override
        public SmoothingModel build() {
            return new SmoothingModel(this);
        }
    }
}

