/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.Collector;
import co.elastic.clients.elasticsearch.core.search.QueryProfile;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SearchProfile
implements JsonpSerializable {
    private final List<Collector> collector;
    private final List<QueryProfile> query;
    private final long rewriteTime;
    public static final JsonpDeserializer<SearchProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchProfile::setupSearchProfileDeserializer, Builder::build);

    public SearchProfile(Builder builder) {
        this.collector = ModelTypeHelper.unmodifiableNonNull(builder.collector, "collector");
        this.query = ModelTypeHelper.unmodifiableNonNull(builder.query, "query");
        this.rewriteTime = Objects.requireNonNull(builder.rewriteTime, "rewrite_time");
    }

    public SearchProfile(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<Collector> collector() {
        return this.collector;
    }

    public List<QueryProfile> query() {
        return this.query;
    }

    public long rewriteTime() {
        return this.rewriteTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("collector");
        generator.writeStartArray();
        for (Collector collector : this.collector) {
            collector.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("query");
        generator.writeStartArray();
        for (QueryProfile queryProfile : this.query) {
            queryProfile.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("rewrite_time");
        generator.write(this.rewriteTime);
    }

    protected static void setupSearchProfileDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::collector, JsonpDeserializer.arrayDeserializer(Collector._DESERIALIZER), "collector", new String[0]);
        op.add(Builder::query, JsonpDeserializer.arrayDeserializer(QueryProfile._DESERIALIZER), "query", new String[0]);
        op.add(Builder::rewriteTime, JsonpDeserializer.longDeserializer(), "rewrite_time", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SearchProfile> {
        private List<Collector> collector;
        private List<QueryProfile> query;
        private Long rewriteTime;

        public Builder collector(List<Collector> value) {
            this.collector = value;
            return this;
        }

        public Builder collector(Collector ... value) {
            this.collector = Arrays.asList(value);
            return this;
        }

        public Builder addCollector(Collector value) {
            if (this.collector == null) {
                this.collector = new ArrayList<Collector>();
            }
            this.collector.add(value);
            return this;
        }

        public Builder collector(Function<Collector.Builder, ObjectBuilder<Collector>> fn) {
            return this.collector(fn.apply(new Collector.Builder()).build());
        }

        public Builder addCollector(Function<Collector.Builder, ObjectBuilder<Collector>> fn) {
            return this.addCollector(fn.apply(new Collector.Builder()).build());
        }

        public Builder query(List<QueryProfile> value) {
            this.query = value;
            return this;
        }

        public Builder query(QueryProfile ... value) {
            this.query = Arrays.asList(value);
            return this;
        }

        public Builder addQuery(QueryProfile value) {
            if (this.query == null) {
                this.query = new ArrayList<QueryProfile>();
            }
            this.query.add(value);
            return this;
        }

        public Builder query(Function<QueryProfile.Builder, ObjectBuilder<QueryProfile>> fn) {
            return this.query(fn.apply(new QueryProfile.Builder()).build());
        }

        public Builder addQuery(Function<QueryProfile.Builder, ObjectBuilder<QueryProfile>> fn) {
            return this.addQuery(fn.apply(new QueryProfile.Builder()).build());
        }

        public Builder rewriteTime(long value) {
            this.rewriteTime = value;
            return this;
        }

        @Override
        public SearchProfile build() {
            return new SearchProfile(this);
        }
    }
}

