/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PointInTimeReference
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final String keepAlive;
    public static final JsonpDeserializer<PointInTimeReference> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PointInTimeReference::setupPointInTimeReferenceDeserializer, Builder::build);

    public PointInTimeReference(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.keepAlive = builder.keepAlive;
    }

    public PointInTimeReference(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String keepAlive() {
        return this.keepAlive;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        if (this.keepAlive != null) {
            generator.writeKey("keep_alive");
            generator.write(this.keepAlive);
        }
    }

    protected static void setupPointInTimeReferenceDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::keepAlive, JsonpDeserializer.stringDeserializer(), "keep_alive", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PointInTimeReference> {
        private String id;
        @Nullable
        private String keepAlive;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder keepAlive(@Nullable String value) {
            this.keepAlive = value;
            return this;
        }

        @Override
        public PointInTimeReference build() {
            return new PointInTimeReference(this);
        }
    }
}

