/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.SuggestMode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DirectGenerator
implements JsonpSerializable {
    private final String field;
    @Nullable
    private final Integer maxEdits;
    @Nullable
    private final Float maxInspections;
    @Nullable
    private final Float maxTermFreq;
    @Nullable
    private final Float minDocFreq;
    @Nullable
    private final Integer minWordLength;
    @Nullable
    private final String postFilter;
    @Nullable
    private final String preFilter;
    @Nullable
    private final Integer prefixLength;
    @Nullable
    private final Integer size;
    @Nullable
    private final SuggestMode suggestMode;
    public static final JsonpDeserializer<DirectGenerator> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DirectGenerator::setupDirectGeneratorDeserializer, Builder::build);

    public DirectGenerator(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.maxEdits = builder.maxEdits;
        this.maxInspections = builder.maxInspections;
        this.maxTermFreq = builder.maxTermFreq;
        this.minDocFreq = builder.minDocFreq;
        this.minWordLength = builder.minWordLength;
        this.postFilter = builder.postFilter;
        this.preFilter = builder.preFilter;
        this.prefixLength = builder.prefixLength;
        this.size = builder.size;
        this.suggestMode = builder.suggestMode;
    }

    public DirectGenerator(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Integer maxEdits() {
        return this.maxEdits;
    }

    @Nullable
    public Float maxInspections() {
        return this.maxInspections;
    }

    @Nullable
    public Float maxTermFreq() {
        return this.maxTermFreq;
    }

    @Nullable
    public Float minDocFreq() {
        return this.minDocFreq;
    }

    @Nullable
    public Integer minWordLength() {
        return this.minWordLength;
    }

    @Nullable
    public String postFilter() {
        return this.postFilter;
    }

    @Nullable
    public String preFilter() {
        return this.preFilter;
    }

    @Nullable
    public Integer prefixLength() {
        return this.prefixLength;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public SuggestMode suggestMode() {
        return this.suggestMode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.maxEdits != null) {
            generator.writeKey("max_edits");
            generator.write(this.maxEdits.intValue());
        }
        if (this.maxInspections != null) {
            generator.writeKey("max_inspections");
            generator.write((double)this.maxInspections.floatValue());
        }
        if (this.maxTermFreq != null) {
            generator.writeKey("max_term_freq");
            generator.write((double)this.maxTermFreq.floatValue());
        }
        if (this.minDocFreq != null) {
            generator.writeKey("min_doc_freq");
            generator.write((double)this.minDocFreq.floatValue());
        }
        if (this.minWordLength != null) {
            generator.writeKey("min_word_length");
            generator.write(this.minWordLength.intValue());
        }
        if (this.postFilter != null) {
            generator.writeKey("post_filter");
            generator.write(this.postFilter);
        }
        if (this.preFilter != null) {
            generator.writeKey("pre_filter");
            generator.write(this.preFilter);
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.suggestMode != null) {
            generator.writeKey("suggest_mode");
            this.suggestMode.serialize(generator, mapper);
        }
    }

    protected static void setupDirectGeneratorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::maxEdits, JsonpDeserializer.integerDeserializer(), "max_edits", new String[0]);
        op.add(Builder::maxInspections, JsonpDeserializer.floatDeserializer(), "max_inspections", new String[0]);
        op.add(Builder::maxTermFreq, JsonpDeserializer.floatDeserializer(), "max_term_freq", new String[0]);
        op.add(Builder::minDocFreq, JsonpDeserializer.floatDeserializer(), "min_doc_freq", new String[0]);
        op.add(Builder::minWordLength, JsonpDeserializer.integerDeserializer(), "min_word_length", new String[0]);
        op.add(Builder::postFilter, JsonpDeserializer.stringDeserializer(), "post_filter", new String[0]);
        op.add(Builder::preFilter, JsonpDeserializer.stringDeserializer(), "pre_filter", new String[0]);
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::suggestMode, SuggestMode._DESERIALIZER, "suggest_mode", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DirectGenerator> {
        private String field;
        @Nullable
        private Integer maxEdits;
        @Nullable
        private Float maxInspections;
        @Nullable
        private Float maxTermFreq;
        @Nullable
        private Float minDocFreq;
        @Nullable
        private Integer minWordLength;
        @Nullable
        private String postFilter;
        @Nullable
        private String preFilter;
        @Nullable
        private Integer prefixLength;
        @Nullable
        private Integer size;
        @Nullable
        private SuggestMode suggestMode;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder maxEdits(@Nullable Integer value) {
            this.maxEdits = value;
            return this;
        }

        public Builder maxInspections(@Nullable Float value) {
            this.maxInspections = value;
            return this;
        }

        public Builder maxTermFreq(@Nullable Float value) {
            this.maxTermFreq = value;
            return this;
        }

        public Builder minDocFreq(@Nullable Float value) {
            this.minDocFreq = value;
            return this;
        }

        public Builder minWordLength(@Nullable Integer value) {
            this.minWordLength = value;
            return this;
        }

        public Builder postFilter(@Nullable String value) {
            this.postFilter = value;
            return this;
        }

        public Builder preFilter(@Nullable String value) {
            this.preFilter = value;
            return this;
        }

        public Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder suggestMode(@Nullable SuggestMode value) {
            this.suggestMode = value;
            return this;
        }

        @Override
        public DirectGenerator build() {
            return new DirectGenerator(this);
        }
    }
}

