/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.scripts_painless_execute;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PainlessContextSetup
implements JsonpSerializable {
    private final JsonData document;
    private final String index;
    private final Query query;
    public static final JsonpDeserializer<PainlessContextSetup> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PainlessContextSetup::setupPainlessContextSetupDeserializer, Builder::build);

    public PainlessContextSetup(Builder builder) {
        this.document = Objects.requireNonNull(builder.document, "document");
        this.index = Objects.requireNonNull(builder.index, "index");
        this.query = Objects.requireNonNull(builder.query, "query");
    }

    public PainlessContextSetup(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public JsonData document() {
        return this.document;
    }

    public String index() {
        return this.index;
    }

    public Query query() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("document");
        this.document.serialize(generator, mapper);
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
    }

    protected static void setupPainlessContextSetupDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::document, JsonData._DESERIALIZER, "document", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PainlessContextSetup> {
        private JsonData document;
        private String index;
        private Query query;

        public Builder document(JsonData value) {
            this.document = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder query(Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Override
        public PainlessContextSetup build() {
            return new PainlessContextSetup(this);
        }
    }
}

