/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.reindex_rethrottle;

import co.elastic.clients.elasticsearch._types.Retries;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ReindexStatus
implements JsonpSerializable {
    private final long batches;
    private final long created;
    private final long deleted;
    private final long noops;
    private final float requestsPerSecond;
    private final Retries retries;
    private final long throttledMillis;
    private final long throttledUntilMillis;
    private final long total;
    private final long updated;
    private final long versionConflicts;
    public static final JsonpDeserializer<ReindexStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexStatus::setupReindexStatusDeserializer, Builder::build);

    public ReindexStatus(Builder builder) {
        this.batches = Objects.requireNonNull(builder.batches, "batches");
        this.created = Objects.requireNonNull(builder.created, "created");
        this.deleted = Objects.requireNonNull(builder.deleted, "deleted");
        this.noops = Objects.requireNonNull(builder.noops, "noops");
        this.requestsPerSecond = Objects.requireNonNull(builder.requestsPerSecond, "requests_per_second").floatValue();
        this.retries = Objects.requireNonNull(builder.retries, "retries");
        this.throttledMillis = Objects.requireNonNull(builder.throttledMillis, "throttled_millis");
        this.throttledUntilMillis = Objects.requireNonNull(builder.throttledUntilMillis, "throttled_until_millis");
        this.total = Objects.requireNonNull(builder.total, "total");
        this.updated = Objects.requireNonNull(builder.updated, "updated");
        this.versionConflicts = Objects.requireNonNull(builder.versionConflicts, "version_conflicts");
    }

    public ReindexStatus(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long batches() {
        return this.batches;
    }

    public long created() {
        return this.created;
    }

    public long deleted() {
        return this.deleted;
    }

    public long noops() {
        return this.noops;
    }

    public float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    public Retries retries() {
        return this.retries;
    }

    public long throttledMillis() {
        return this.throttledMillis;
    }

    public long throttledUntilMillis() {
        return this.throttledUntilMillis;
    }

    public long total() {
        return this.total;
    }

    public long updated() {
        return this.updated;
    }

    public long versionConflicts() {
        return this.versionConflicts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("batches");
        generator.write(this.batches);
        generator.writeKey("created");
        generator.write(this.created);
        generator.writeKey("deleted");
        generator.write(this.deleted);
        generator.writeKey("noops");
        generator.write(this.noops);
        generator.writeKey("requests_per_second");
        generator.write((double)this.requestsPerSecond);
        generator.writeKey("retries");
        this.retries.serialize(generator, mapper);
        generator.writeKey("throttled_millis");
        generator.write(this.throttledMillis);
        generator.writeKey("throttled_until_millis");
        generator.write(this.throttledUntilMillis);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("updated");
        generator.write(this.updated);
        generator.writeKey("version_conflicts");
        generator.write(this.versionConflicts);
    }

    protected static void setupReindexStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::batches, JsonpDeserializer.longDeserializer(), "batches", new String[0]);
        op.add(Builder::created, JsonpDeserializer.longDeserializer(), "created", new String[0]);
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted", new String[0]);
        op.add(Builder::noops, JsonpDeserializer.longDeserializer(), "noops", new String[0]);
        op.add(Builder::requestsPerSecond, JsonpDeserializer.floatDeserializer(), "requests_per_second", new String[0]);
        op.add(Builder::retries, Retries._DESERIALIZER, "retries", new String[0]);
        op.add(Builder::throttledMillis, JsonpDeserializer.longDeserializer(), "throttled_millis", new String[0]);
        op.add(Builder::throttledUntilMillis, JsonpDeserializer.longDeserializer(), "throttled_until_millis", new String[0]);
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
        op.add(Builder::updated, JsonpDeserializer.longDeserializer(), "updated", new String[0]);
        op.add(Builder::versionConflicts, JsonpDeserializer.longDeserializer(), "version_conflicts", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ReindexStatus> {
        private Long batches;
        private Long created;
        private Long deleted;
        private Long noops;
        private Float requestsPerSecond;
        private Retries retries;
        private Long throttledMillis;
        private Long throttledUntilMillis;
        private Long total;
        private Long updated;
        private Long versionConflicts;

        public Builder batches(long value) {
            this.batches = value;
            return this;
        }

        public Builder created(long value) {
            this.created = value;
            return this;
        }

        public Builder deleted(long value) {
            this.deleted = value;
            return this;
        }

        public Builder noops(long value) {
            this.noops = value;
            return this;
        }

        public Builder requestsPerSecond(float value) {
            this.requestsPerSecond = Float.valueOf(value);
            return this;
        }

        public Builder retries(Retries value) {
            this.retries = value;
            return this;
        }

        public Builder retries(Function<Retries.Builder, ObjectBuilder<Retries>> fn) {
            return this.retries(fn.apply(new Retries.Builder()).build());
        }

        public Builder throttledMillis(long value) {
            this.throttledMillis = value;
            return this;
        }

        public Builder throttledUntilMillis(long value) {
            this.throttledUntilMillis = value;
            return this;
        }

        public Builder total(long value) {
            this.total = value;
            return this;
        }

        public Builder updated(long value) {
            this.updated = value;
            return this;
        }

        public Builder versionConflicts(long value) {
            this.versionConflicts = value;
            return this;
        }

        @Override
        public ReindexStatus build() {
            return new ReindexStatus(this);
        }
    }
}

