/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.reindex;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SourceRuntimeMapping
implements JsonpSerializable {
    private final String type;
    @Nullable
    private final String script;
    public static final JsonpDeserializer<SourceRuntimeMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SourceRuntimeMapping::setupSourceRuntimeMappingDeserializer, Builder::build);

    public SourceRuntimeMapping(Builder builder) {
        this.type = Objects.requireNonNull(builder.type, "type");
        this.script = builder.script;
    }

    public SourceRuntimeMapping(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String type() {
        return this.type;
    }

    @Nullable
    public String script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
    }

    protected static void setupSourceRuntimeMappingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(Builder::script, JsonpDeserializer.stringDeserializer(), "script", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SourceRuntimeMapping> {
        private String type;
        @Nullable
        private String script;

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder script(@Nullable String value) {
            this.script = value;
            return this;
        }

        @Override
        public SourceRuntimeMapping build() {
            return new SourceRuntimeMapping(this);
        }
    }
}

