/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.mtermvectors;

import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch.core.termvectors.Filter;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Operation
implements JsonpSerializable {
    private final JsonValue doc;
    private final List<String> fields;
    private final boolean fieldStatistics;
    private final Filter filter;
    private final String id;
    private final String index;
    private final boolean offsets;
    private final boolean payloads;
    private final boolean positions;
    private final String routing;
    private final boolean termStatistics;
    private final long version;
    private final VersionType versionType;
    public static final JsonpDeserializer<Operation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Operation::setupOperationDeserializer, Builder::build);

    public Operation(Builder builder) {
        this.doc = Objects.requireNonNull(builder.doc, "doc");
        this.fields = ModelTypeHelper.unmodifiableNonNull(builder.fields, "fields");
        this.fieldStatistics = Objects.requireNonNull(builder.fieldStatistics, "field_statistics");
        this.filter = Objects.requireNonNull(builder.filter, "filter");
        this.id = Objects.requireNonNull(builder.id, "_id");
        this.index = Objects.requireNonNull(builder.index, "_index");
        this.offsets = Objects.requireNonNull(builder.offsets, "offsets");
        this.payloads = Objects.requireNonNull(builder.payloads, "payloads");
        this.positions = Objects.requireNonNull(builder.positions, "positions");
        this.routing = Objects.requireNonNull(builder.routing, "routing");
        this.termStatistics = Objects.requireNonNull(builder.termStatistics, "term_statistics");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.versionType = Objects.requireNonNull(builder.versionType, "version_type");
    }

    public Operation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public JsonValue doc() {
        return this.doc;
    }

    public List<String> fields() {
        return this.fields;
    }

    public boolean fieldStatistics() {
        return this.fieldStatistics;
    }

    public Filter filter() {
        return this.filter;
    }

    public String id() {
        return this.id;
    }

    public String index() {
        return this.index;
    }

    public boolean offsets() {
        return this.offsets;
    }

    public boolean payloads() {
        return this.payloads;
    }

    public boolean positions() {
        return this.positions;
    }

    public String routing() {
        return this.routing;
    }

    public boolean termStatistics() {
        return this.termStatistics;
    }

    public long version() {
        return this.version;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("doc");
        generator.write(this.doc);
        generator.writeKey("fields");
        generator.writeStartArray();
        for (String item0 : this.fields) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("field_statistics");
        generator.write(this.fieldStatistics);
        generator.writeKey("filter");
        this.filter.serialize(generator, mapper);
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("offsets");
        generator.write(this.offsets);
        generator.writeKey("payloads");
        generator.write(this.payloads);
        generator.writeKey("positions");
        generator.write(this.positions);
        generator.writeKey("routing");
        generator.write(this.routing);
        generator.writeKey("term_statistics");
        generator.write(this.termStatistics);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("version_type");
        this.versionType.serialize(generator, mapper);
    }

    protected static void setupOperationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::doc, JsonpDeserializer.jsonValueDeserializer(), "doc", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields", new String[0]);
        op.add(Builder::fieldStatistics, JsonpDeserializer.booleanDeserializer(), "field_statistics", new String[0]);
        op.add(Builder::filter, Filter._DESERIALIZER, "filter", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(Builder::offsets, JsonpDeserializer.booleanDeserializer(), "offsets", new String[0]);
        op.add(Builder::payloads, JsonpDeserializer.booleanDeserializer(), "payloads", new String[0]);
        op.add(Builder::positions, JsonpDeserializer.booleanDeserializer(), "positions", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing", new String[0]);
        op.add(Builder::termStatistics, JsonpDeserializer.booleanDeserializer(), "term_statistics", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Operation> {
        private JsonValue doc;
        private List<String> fields;
        private Boolean fieldStatistics;
        private Filter filter;
        private String id;
        private String index;
        private Boolean offsets;
        private Boolean payloads;
        private Boolean positions;
        private String routing;
        private Boolean termStatistics;
        private Long version;
        private VersionType versionType;

        public Builder doc(JsonValue value) {
            this.doc = value;
            return this;
        }

        public Builder fields(List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder fieldStatistics(boolean value) {
            this.fieldStatistics = value;
            return this;
        }

        public Builder filter(Filter value) {
            this.filter = value;
            return this;
        }

        public Builder filter(Function<Filter.Builder, ObjectBuilder<Filter>> fn) {
            return this.filter(fn.apply(new Filter.Builder()).build());
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder offsets(boolean value) {
            this.offsets = value;
            return this;
        }

        public Builder payloads(boolean value) {
            this.payloads = value;
            return this;
        }

        public Builder positions(boolean value) {
            this.positions = value;
            return this;
        }

        public Builder routing(String value) {
            this.routing = value;
            return this;
        }

        public Builder termStatistics(boolean value) {
            this.termStatistics = value;
            return this;
        }

        public Builder version(long value) {
            this.version = value;
            return this;
        }

        public Builder versionType(VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        public Operation build() {
            return new Operation(this);
        }
    }
}

