/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.msearch_template;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TemplateItem
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final List<String> index;
    @Nullable
    private final Map<String, JsonData> params;
    @Nullable
    private final String source;
    public static final JsonpDeserializer<TemplateItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TemplateItem::setupTemplateItemDeserializer, Builder::build);

    public TemplateItem(Builder builder) {
        this.id = builder.id;
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.params = ModelTypeHelper.unmodifiable(builder.params);
        this.source = builder.source;
    }

    public TemplateItem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public String source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.writeStartArray();
            for (String string : this.index) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.params != null) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry entry : this.params.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("source");
            generator.write(this.source);
        }
    }

    protected static void setupTemplateItemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::index, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index", new String[0]);
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params", new String[0]);
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TemplateItem> {
        @Nullable
        private String id;
        @Nullable
        private List<String> index;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private String source;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder params(@Nullable Map<String, JsonData> value) {
            this.params = value;
            return this;
        }

        public Builder putParams(String key, JsonData value) {
            if (this.params == null) {
                this.params = new HashMap<String, JsonData>();
            }
            this.params.put(key, value);
            return this;
        }

        public Builder source(@Nullable String value) {
            this.source = value;
            return this;
        }

        @Override
        public TemplateItem build() {
            return new TemplateItem(this);
        }
    }
}

