/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.mget;

import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Operation
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final String index;
    @Nullable
    private final String routing;
    @Nullable
    private final JsonValue source;
    @Nullable
    private final List<String> storedFields;
    @Nullable
    private final String type;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<Operation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Operation::setupOperationDeserializer, Builder::build);

    public Operation(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "_id");
        this.index = builder.index;
        this.routing = builder.routing;
        this.source = builder.source;
        this.storedFields = ModelTypeHelper.unmodifiable(builder.storedFields);
        this.type = builder.type;
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public Operation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public JsonValue source() {
        return this.source;
    }

    @Nullable
    public List<String> storedFields() {
        return this.storedFields;
    }

    @Nullable
    public String type() {
        return this.type;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Nullable
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            generator.write(this.source);
        }
        if (this.storedFields != null) {
            generator.writeKey("stored_fields");
            generator.writeStartArray();
            for (String item0 : this.storedFields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    protected static void setupOperationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing", new String[0]);
        op.add(Builder::source, JsonpDeserializer.jsonValueDeserializer(), "_source", new String[0]);
        op.add(Builder::storedFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stored_fields", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Operation> {
        private String id;
        @Nullable
        private String index;
        @Nullable
        private String routing;
        @Nullable
        private JsonValue source;
        @Nullable
        private List<String> storedFields;
        @Nullable
        private String type;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder source(@Nullable JsonValue value) {
            this.source = value;
            return this;
        }

        public Builder storedFields(@Nullable List<String> value) {
            this.storedFields = value;
            return this;
        }

        public Builder storedFields(String ... value) {
            this.storedFields = Arrays.asList(value);
            return this;
        }

        public Builder addStoredFields(String value) {
            if (this.storedFields == null) {
                this.storedFields = new ArrayList<String>();
            }
            this.storedFields.add(value);
            return this;
        }

        public Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        public Operation build() {
            return new Operation(this);
        }
    }
}

