/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.get_script_context;

import co.elastic.clients.elasticsearch.core.get_script_context.ContextMethod;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Context
implements JsonpSerializable {
    private final List<ContextMethod> methods;
    private final String name;
    public static final JsonpDeserializer<Context> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Context::setupContextDeserializer, Builder::build);

    public Context(Builder builder) {
        this.methods = ModelTypeHelper.unmodifiableNonNull(builder.methods, "methods");
        this.name = Objects.requireNonNull(builder.name, "name");
    }

    public Context(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<ContextMethod> methods() {
        return this.methods;
    }

    public String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("methods");
        generator.writeStartArray();
        for (ContextMethod item0 : this.methods) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("name");
        generator.write(this.name);
    }

    protected static void setupContextDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::methods, JsonpDeserializer.arrayDeserializer(ContextMethod._DESERIALIZER), "methods", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Context> {
        private List<ContextMethod> methods;
        private String name;

        public Builder methods(List<ContextMethod> value) {
            this.methods = value;
            return this;
        }

        public Builder methods(ContextMethod ... value) {
            this.methods = Arrays.asList(value);
            return this;
        }

        public Builder addMethods(ContextMethod value) {
            if (this.methods == null) {
                this.methods = new ArrayList<ContextMethod>();
            }
            this.methods.add(value);
            return this;
        }

        public Builder methods(Function<ContextMethod.Builder, ObjectBuilder<ContextMethod>> fn) {
            return this.methods(fn.apply(new ContextMethod.Builder()).build());
        }

        public Builder addMethods(Function<ContextMethod.Builder, ObjectBuilder<ContextMethod>> fn) {
            return this.addMethods(fn.apply(new ContextMethod.Builder()).build());
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        public Context build() {
            return new Context(this);
        }
    }
}

