/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.field_caps;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FieldCapability
implements JsonpSerializable {
    private final boolean aggregatable;
    @Nullable
    private final List<String> indices;
    @Nullable
    private final Map<String, List<String>> meta;
    @Nullable
    private final List<String> nonAggregatableIndices;
    @Nullable
    private final List<String> nonSearchableIndices;
    private final boolean searchable;
    private final String type;
    @Nullable
    private final Boolean metadataField;
    public static final JsonpDeserializer<FieldCapability> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldCapability::setupFieldCapabilityDeserializer, Builder::build);

    public FieldCapability(Builder builder) {
        this.aggregatable = Objects.requireNonNull(builder.aggregatable, "aggregatable");
        this.indices = ModelTypeHelper.unmodifiable(builder.indices);
        this.meta = ModelTypeHelper.unmodifiable(builder.meta);
        this.nonAggregatableIndices = ModelTypeHelper.unmodifiable(builder.nonAggregatableIndices);
        this.nonSearchableIndices = ModelTypeHelper.unmodifiable(builder.nonSearchableIndices);
        this.searchable = Objects.requireNonNull(builder.searchable, "searchable");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.metadataField = builder.metadataField;
    }

    public FieldCapability(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean aggregatable() {
        return this.aggregatable;
    }

    @Nullable
    public List<String> indices() {
        return this.indices;
    }

    @Nullable
    public Map<String, List<String>> meta() {
        return this.meta;
    }

    @Nullable
    public List<String> nonAggregatableIndices() {
        return this.nonAggregatableIndices;
    }

    @Nullable
    public List<String> nonSearchableIndices() {
        return this.nonSearchableIndices;
    }

    public boolean searchable() {
        return this.searchable;
    }

    public String type() {
        return this.type;
    }

    @Nullable
    public Boolean metadataField() {
        return this.metadataField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aggregatable");
        generator.write(this.aggregatable);
        if (this.indices != null) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.meta != null) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                for (String item1 : (List)entry.getValue()) {
                    generator.write(item1);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.nonAggregatableIndices != null) {
            generator.writeKey("non_aggregatable_indices");
            generator.writeStartArray();
            for (String string : this.nonAggregatableIndices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.nonSearchableIndices != null) {
            generator.writeKey("non_searchable_indices");
            generator.writeStartArray();
            for (String string : this.nonSearchableIndices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("searchable");
        generator.write(this.searchable);
        generator.writeKey("type");
        generator.write(this.type);
        if (this.metadataField != null) {
            generator.writeKey("metadata_field");
            generator.write(this.metadataField.booleanValue());
        }
    }

    protected static void setupFieldCapabilityDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aggregatable, JsonpDeserializer.booleanDeserializer(), "aggregatable", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "meta", new String[0]);
        op.add(Builder::nonAggregatableIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "non_aggregatable_indices", new String[0]);
        op.add(Builder::nonSearchableIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "non_searchable_indices", new String[0]);
        op.add(Builder::searchable, JsonpDeserializer.booleanDeserializer(), "searchable", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(Builder::metadataField, JsonpDeserializer.booleanDeserializer(), "metadata_field", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldCapability> {
        private Boolean aggregatable;
        @Nullable
        private List<String> indices;
        @Nullable
        private Map<String, List<String>> meta;
        @Nullable
        private List<String> nonAggregatableIndices;
        @Nullable
        private List<String> nonSearchableIndices;
        private Boolean searchable;
        private String type;
        @Nullable
        private Boolean metadataField;

        public Builder aggregatable(boolean value) {
            this.aggregatable = value;
            return this;
        }

        public Builder indices(@Nullable List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder meta(@Nullable Map<String, List<String>> value) {
            this.meta = value;
            return this;
        }

        public Builder putMeta(String key, List<String> value) {
            if (this.meta == null) {
                this.meta = new HashMap<String, List<String>>();
            }
            this.meta.put(key, value);
            return this;
        }

        public Builder nonAggregatableIndices(@Nullable List<String> value) {
            this.nonAggregatableIndices = value;
            return this;
        }

        public Builder nonAggregatableIndices(String ... value) {
            this.nonAggregatableIndices = Arrays.asList(value);
            return this;
        }

        public Builder addNonAggregatableIndices(String value) {
            if (this.nonAggregatableIndices == null) {
                this.nonAggregatableIndices = new ArrayList<String>();
            }
            this.nonAggregatableIndices.add(value);
            return this;
        }

        public Builder nonSearchableIndices(@Nullable List<String> value) {
            this.nonSearchableIndices = value;
            return this;
        }

        public Builder nonSearchableIndices(String ... value) {
            this.nonSearchableIndices = Arrays.asList(value);
            return this;
        }

        public Builder addNonSearchableIndices(String value) {
            if (this.nonSearchableIndices == null) {
                this.nonSearchableIndices = new ArrayList<String>();
            }
            this.nonSearchableIndices.add(value);
            return this;
        }

        public Builder searchable(boolean value) {
            this.searchable = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder metadataField(@Nullable Boolean value) {
            this.metadataField = value;
            return this;
        }

        @Override
        public FieldCapability build() {
            return new FieldCapability(this);
        }
    }
}

