/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.bulk;

import co.elastic.clients.elasticsearch.core.bulk.CreateResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.DeleteResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.IndexResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.ResponseItemVariant;
import co.elastic.clients.elasticsearch.core.bulk.UpdateResponseItem;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class ResponseItem
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String INDEX = "index";
    public static final String CREATE = "create";
    public static final String UPDATE = "update";
    public static final String DELETE = "delete";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<ResponseItem> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, ResponseItem::setupResponseItemDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public ResponseItem(ResponseItemVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends ResponseItemVariant> ResponseItem(ObjectBuilder<T> builder) {
        this((ResponseItemVariant)builder.build());
    }

    private ResponseItem(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public ResponseItem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public IndexResponseItem index() {
        return (IndexResponseItem)TaggedUnionUtils.get(this, INDEX);
    }

    public CreateResponseItem create() {
        return (CreateResponseItem)TaggedUnionUtils.get(this, CREATE);
    }

    public UpdateResponseItem update() {
        return (UpdateResponseItem)TaggedUnionUtils.get(this, UPDATE);
    }

    public DeleteResponseItem delete() {
        return (DeleteResponseItem)TaggedUnionUtils.get(this, DELETE);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupResponseItemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::index, IndexResponseItem._DESERIALIZER, INDEX, new String[0]);
        op.add(Builder::create, CreateResponseItem._DESERIALIZER, CREATE, new String[0]);
        op.add(Builder::update, UpdateResponseItem._DESERIALIZER, UPDATE, new String[0]);
        op.add(Builder::delete, DeleteResponseItem._DESERIALIZER, DELETE, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ResponseItem> {
        private String _type;
        private Object _value;

        public Builder index(IndexResponseItem v) {
            this._type = ResponseItem.INDEX;
            this._value = v;
            return this;
        }

        public Builder index(Function<IndexResponseItem.Builder, ObjectBuilder<IndexResponseItem>> f) {
            return this.index(f.apply(new IndexResponseItem.Builder()).build());
        }

        public Builder create(CreateResponseItem v) {
            this._type = ResponseItem.CREATE;
            this._value = v;
            return this;
        }

        public Builder create(Function<CreateResponseItem.Builder, ObjectBuilder<CreateResponseItem>> f) {
            return this.create(f.apply(new CreateResponseItem.Builder()).build());
        }

        public Builder update(UpdateResponseItem v) {
            this._type = ResponseItem.UPDATE;
            this._value = v;
            return this;
        }

        public Builder update(Function<UpdateResponseItem.Builder, ObjectBuilder<UpdateResponseItem>> f) {
            return this.update(f.apply(new UpdateResponseItem.Builder()).build());
        }

        public Builder delete(DeleteResponseItem v) {
            this._type = ResponseItem.DELETE;
            this._value = v;
            return this;
        }

        public Builder delete(Function<DeleteResponseItem.Builder, ObjectBuilder<DeleteResponseItem>> f) {
            return this.delete(f.apply(new DeleteResponseItem.Builder()).build());
        }

        @Override
        public ResponseItem build() {
            return new ResponseItem(this);
        }
    }
}

