/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.TermsEnumResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TermsEnumRequest
extends RequestBase
implements JsonpSerializable {
    private final String index;
    private final String field;
    @Nullable
    private final Integer size;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean caseInsensitive;
    @Nullable
    private final Query indexFilter;
    @Nullable
    private final String string;
    @Nullable
    private final String searchAfter;
    public static final JsonpDeserializer<TermsEnumRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsEnumRequest::setupTermsEnumRequestDeserializer, Builder::build);
    public static final Endpoint<TermsEnumRequest, TermsEnumResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<TermsEnumRequest, TermsEnumResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_terms_enum");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, TermsEnumResponse._DESERIALIZER);

    public TermsEnumRequest(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.field = Objects.requireNonNull(builder.field, "field");
        this.size = builder.size;
        this.timeout = builder.timeout;
        this.caseInsensitive = builder.caseInsensitive;
        this.indexFilter = builder.indexFilter;
        this.string = builder.string;
        this.searchAfter = builder.searchAfter;
    }

    public TermsEnumRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Nullable
    public Query indexFilter() {
        return this.indexFilter;
    }

    @Nullable
    public String string() {
        return this.string;
    }

    @Nullable
    public String searchAfter() {
        return this.searchAfter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            generator.write(this.timeout);
        }
        if (this.caseInsensitive != null) {
            generator.writeKey("case_insensitive");
            generator.write(this.caseInsensitive.booleanValue());
        }
        if (this.indexFilter != null) {
            generator.writeKey("index_filter");
            this.indexFilter.serialize(generator, mapper);
        }
        if (this.string != null) {
            generator.writeKey("string");
            generator.write(this.string);
        }
        if (this.searchAfter != null) {
            generator.writeKey("search_after");
            generator.write(this.searchAfter);
        }
    }

    protected static void setupTermsEnumRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout", new String[0]);
        op.add(Builder::caseInsensitive, JsonpDeserializer.booleanDeserializer(), "case_insensitive", new String[0]);
        op.add(Builder::indexFilter, Query._DESERIALIZER, "index_filter", new String[0]);
        op.add(Builder::string, JsonpDeserializer.stringDeserializer(), "string", new String[0]);
        op.add(Builder::searchAfter, JsonpDeserializer.stringDeserializer(), "search_after", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TermsEnumRequest> {
        private String index;
        private String field;
        @Nullable
        private Integer size;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean caseInsensitive;
        @Nullable
        private Query indexFilter;
        @Nullable
        private String string;
        @Nullable
        private String searchAfter;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder caseInsensitive(@Nullable Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        public Builder indexFilter(@Nullable Query value) {
            this.indexFilter = value;
            return this;
        }

        public Builder indexFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.indexFilter(fn.apply(new Query.Builder()).build());
        }

        public Builder string(@Nullable String value) {
            this.string = value;
            return this;
        }

        public Builder searchAfter(@Nullable String value) {
            this.searchAfter = value;
            return this;
        }

        @Override
        public TermsEnumRequest build() {
            return new TermsEnumRequest(this);
        }
    }
}

